<p align="center">
   <p align="center">
      <img align="center" width="40%" src = "https://github.com/AlbertGBarber/Pixel-Spork-Wiki-Images/blob/main/Logo/Logo%20Rainbow.png" alt="Pixel Spork Logo">
      <a href="https://youtu.be/n6MAIFuHd8U"><img align="center"  width="40%" src="https://github.com/AlbertGBarber/Pixel-Spork-Wiki-Images/blob/main/Images/Thumb%20Play.png"></a>
   </p>
   <p align="center">
      <a href="https://reference.arduino.cc/reference/en/libraries/pixel_spork/"</a><img src="https://img.shields.io/badge/Pixel%20Spork-DarkGreen?logo=Arduino&logoColor=Grey&label=Library%20Manager"></a>
      <a href="https://github.com/AlbertGBarber/PixelSpork/wiki/"</a><img src="https://img.shields.io/badge/Wiki-blue?style=flat-square&logo=Wikipedia&labelColor=black"></a>
      <a href="https://discord.gg/HVeD8BgVTW"><img src="https://img.shields.io/badge/Discord-blue?style=flat-square&logo=discord&labelColor=black"></a>
      <a href="https://github.com/AlbertGBarber/PixelSpork/wiki/Overview"><img src="https://img.shields.io/badge/Starter%20Guide-blue?style=flat-square&logo=Github&labelColor=black"></a>
      <a href="https://github.com/AlbertGBarber/PixelSpork/blob/main/LICENSE"><img src="https://img.shields.io/github/license/AlbertGBarber/PixelSpork?color=blue&style=flat-square&labelColor=black"></a>
   </p>
</p>

# Welcome!

Pixel Spork is an Arduino library for controlling addressable LEDs. It aims to streamline the use of the popular WS2812 (and other) addressable LEDs by providing a wide variety of rich, class-based, effects and utilities. The library's stand-out feature is "[Segment Sets](https://github.com/AlbertGBarber/PixelSpork/wiki/Ring-Segments-Example)", which allow you to intuitively arrange your LEDs into virtual 2D shapes. Effects map onto these shapes automatically, streamlining your coding experience. Pixel Spork lets users code at their own comfort level by only requiring a few core tools to operate, but providing many more for power users. Start small with a simple 1D Segment Set and effect, and scale up over time to fully 2D Segment Sets, using multiple effects, while managing multiple palettes, color modes, utilities and more!

Check out the [Youtube Trailer](https://youtu.be/n6MAIFuHd8U) for more!

[![ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/K3K713QB3L) 

Features:

* Over 40 class-based, deeply customizable [effects](https://github.com/AlbertGBarber/PixelSpork/wiki/Effect-Samples).

* Virtually re-arrange your LEDs into 1D or 2D shapes using [Segment Sets](https://github.com/AlbertGBarber/PixelSpork/wiki/Ring-Segments-Example).

* Use a suite of [utility classes](https://github.com/AlbertGBarber/PixelSpork/wiki/Utility-Classes-Basics) to manage and enhance your effects.

* Add rainbows (or a custom gradients) to most effects using [Color Modes](https://github.com/AlbertGBarber/PixelSpork/wiki/Color-Modes).

* Create [color palettes](https://github.com/AlbertGBarber/PixelSpork/wiki/Palette-Basics) to unify colors across your code.

* Compartmentalized design. Most features are optional, meaning that you only need to interact with them if you want to, allowing you to explore and code at your own pace.

* Uses the famous [FastLED](https://github.com/FastLED/FastLED) library as a foundation, ensuring that writing to LEDs is as fast as possible.

* Fully documented, both in the [Gitub Wiki](https://github.com/AlbertGBarber/PixelSpork/wiki) and in the code itself. I hate wading through incomplete wikis and unexplained code. I pledge that I will do my very best to keep this wiki complete and up-to-date. If you ever find a topic/feature that isn't explained or is incomplete, please let me know (by opening an issue, etc)!

### To get started, check out the [starter guide](https://github.com/AlbertGBarber/PixelSpork/wiki/Overview)!

### Join the Discord Server!

<a href="https://discord.gg/HVeD8BgVTW"><img src="https://discordapp.com/api/guilds/1235341175175774361/widget.png?style=banner2" width="25%"></a>

If needed, you can can DM me on [Discord](https://discord.com/users/abarb_255) or [Reddit](https://www.reddit.com/user/splat2385/).
