# ESP32 Mecanum 4WD Robot

Примеры управления роботом с меканум колесами на ESP32 с драйвером ZK-5AD.

## 📋 Содержание

1. **ESP32_Mecanum_4WD.ino** - Автоматическая демонстрация всех возможностей меканум-колес
2. **ESP32_Mecanum_Serial_Control.ino** - Интерактивное управление через Serial Monitor

## 🔌 Подключение

### Моторы (режим PWM_PWM)
```
Motor 1 (Передний левый):  IN1 -> GPIO 32, IN2 -> GPIO 33
Motor 2 (Передний правый): IN1 -> GPIO 25, IN2 -> GPIO 26
Motor 3 (Задний левый):    IN1 -> GPIO 19, IN2 -> GPIO 18
Motor 4 (Задний правый):    IN1 -> GPIO 17, IN2 -> GPIO 16
```

### Питание драйвера
```
VCC -> 5V или 3.3V
GND -> GND
VM  -> Питание моторов (6-12V)
```

## 🎯 Расположение колес

```
     ПЕРЕДНЯЯ ЧАСТЬ
    M1 ↗     ↖ M2
         [ ]
    M3 ↖     ↗ M4
     ЗАДНЯЯ ЧАСТЬ
```

**Направление роликов:**
- M1 (FL): / (диагональ вправо)
- M2 (FR): \ (диагональ влево)
- M3 (RL): \ (диагональ влево)
- M4 (RR): / (диагональ вправо)

## 🚀 Возможности меканум-колес

### Базовые движения
- ⬆️ **Вперед** - все колеса вращаются вперед
- ⬇️ **Назад** - все колеса вращаются назад
- ⬅️ **Влево** (страфинг) - диагональное вращение роликов
- ➡️ **Вправо** (страфинг) - диагональное вращение роликов

### Диагональные движения
- ↖️ **Вперед-влево** - комбинация движений
- ↗️ **Вперед-вправо** - комбинация движений
- ↙️ **Назад-влево** - комбинация движений
- ↘️ **Назад-вправо** - комбинация движений

### Вращение на месте
- 🔄 **По часовой стрелке** - противоположное вращение сторон
- 🔃 **Против часовой стрелки** - противоположное вращение сторон

## 📐 Математика меканум-колес

Формулы для расчета скоростей моторов:

```cpp
speedFL = vx + vy + rotation;  // Передний левый
speedFR = vx - vy - rotation;  // Передний правый
speedRL = vx - vy + rotation;  // Задний левый
speedRR = vx + vy - rotation;  // Задний правый
```

Где:
- `vx` - скорость вперед/назад (-100 до 100)
- `vy` - скорость влево/вправо (-100 до 100)
- `rotation` - скорость вращения (-100 до 100)

## 🎮 Управление через Serial Monitor

В примере **ESP32_Mecanum_Serial_Control.ino** доступны следующие команды:

### Движение
- `w` - вперед
- `s` - назад
- `a` - влево
- `d` - вправо

### Диагонали
- `q` - вперед-влево
- `e` - вперед-вправо
- `z` - назад-влево
- `c` - назад-вправо

### Вращение
- `j` - против часовой
- `l` - по часовой

### Остановка
- `x` - стоп (свободная остановка)
- `b` - тормоз (активное торможение)

### Скорость
- `+` - увеличить скорость
- `-` - уменьшить скорость

### Помощь
- `h` - показать список команд

## 💡 Советы по использованию

1. **Калибровка**: Если робот движется не прямо, проверьте:
   - Правильность подключения моторов
   - Направление вращения каждого мотора
   - Одинаковое давление в колесах

2. **Оптимальная скорость**: Начните с 50-60% для тестирования

3. **Страфинг**: Требует хорошего сцепления колес с поверхностью

4. **Диагональное движение**: Самое эффективное движение меканум-колес

5. **Поверхность**: Работает лучше на гладких поверхностях (плитка, ламинат)

## 🔧 Настройка

Если движения не соответствуют описанию, попробуйте:

1. **Изменить направление мотора** - поменяйте местами IN1 и IN2 для проблемного мотора
2. **Проверить расположение колес** - убедитесь, что ролики направлены правильно
3. **Изменить формулы** - возможно нужна корректировка для вашей конфигурации

## 📚 Дополнительная информация

- [Alash Electronics](https://alash-electronics.kz/)
- [Документация библиотеки](https://github.com/Alash-electronics/AlashMotorControlLite)

---

**Alash Engineering** | 2024
