/*
 * Программа демонстрирует работу с ИК-приёмником и библиотекой AlashIRControl. 
 * При нажатии любой кнопки на любом пульте, код кнопки и длина сообщения отображаются в монитор последовательного порта.
*/

// Библиотека AlashIRControl для работы с ИК приёмопередатчиками разработана https://alash-electronics.kz/
// Для считывания данных с ИК-пульта предлагаем воспользоваться ИК-приёмником https://alash-electronics.kz/collection/sveta-i-tsveta/product/modul-ik-datchika-vs1838b-ky-022

#include <AlashIRControlRX.h> // Подключаем библиотеку для работы с ИК-приёмником
AlashIRControlRX irReceiver(7); // Объявляем объект irReceiver, с указанием вывода к которому подключён ИК-приёмник

void setup() {
  Serial.begin(9600); // Инициируем передачу данных в монитор последовательного порта на скорости 9600 бит/сек
  irReceiver.begin(); // Инициируем работу с ИК-приёмником
}
void loop() {
  if (irReceiver.check()) { // Если в буфере имеются данные, принятые с пульта (была нажата кнопка)
    Serial.println(irReceiver.data, HEX); // Выводим код нажатой кнопки в шестнадцатеричном формате
    Serial.println(irReceiver.length); // Выводим количество бит в коде
  }
}
