/*
 * Бұл код ИҚ-таратқышты басқару үшін AlashIRControl кітапханасын пайдаланады.
 * setup() ішінде батырма пиндері конфигурацияланады және ИҚ-таратқыш хаттамамен инициализацияланады.
 * loop() циклінде 6, 7 және 8 пиндеріндегі батырмалардың басылуы тексеріледі және сәйкес ИҚ-кодтар жіберіледі.
*/

// AlashIRControl кітапханасы ИҚ-қабылдағыштармен жұмыс үшін https://alash-electronics.kz/ дайындалған
// Деректерді жіберу үшін ИҚ-таратқышты пайдалануды ұсынамыз

#include <AlashIRControlTX.h> // ИҚ-таратқышпен жұмыс істеу үшін кітапхананы қосу
AlashIRControlTX irTransmitter(2); // irTransmitter объектісін жариялау, ИҚ-таратқыш қосылған пинді көрсету

void setup() {
  irTransmitter.begin(); // ИҚ-таратқышты инициализациялау
  pinMode(6, INPUT); // Батырма қосылған 6-пинді кіріс ретінде конфигурациялау
  pinMode(7, INPUT); // Батырма қосылған 7-пинді кіріс ретінде конфигурациялау
  pinMode(8, INPUT); // Батырма қосылған 8-пинді кіріс ретінде конфигурациялау
  irTransmitter.protocol("AeQQV~zK]Kp^KJp[@@@@@@@Bp"); // ELENBERG пультінен деректерді жіберу хаттамасын көрсету
}
void loop() {
  if (digitalRead(6)) {
    irTransmitter.send(0x417, true); // Егер 6-пиндегі батырма басылса, ON/OFF сигналын қайталау пакеттерімен жіберу
  }
  if (digitalRead(7)) {
    irTransmitter.send(0x425, true); // Егер 7-пиндегі батырма басылса, VOL- сигналын қайталау пакеттерімен жіберу
  }
  if (digitalRead(8)) {
    irTransmitter.send(0x427); // Егер 8-пиндегі батырма басылса, VOL+ сигналын қайталау пакеттерінсіз жіберу
  }
}

/*
 * Әдепкі бойынша, жіберілетін деректер үзіліс ұзындығымен кодталады.
 * protocol() функциясын пайдаланып кодтауды және хаттаманы өзгертуге болады.
 * transmitter_SetProtocol мысалын қараңыз.
 */
