# AlashIRControl Examples / Примеры / Мысалдар

This folder contains examples in three languages:
Эта папка содержит примеры на трёх языках:
Бұл қалтада үш тілдегі мысалдар бар:

## 📁 Folder Structure / Структура папок / Қалталар құрылымы

### 🇬🇧 [en/](en/) - English Examples
Examples with comments in English for international users.

### 🇷🇺 [ru/](ru/) - Русские примеры
Примеры с комментариями на русском языке.

### 🇰🇿 [kk/](kk/) - Қазақша мысалдар
Қазақ тіліндегі түсініктемелері бар мысалдар.

---

## 📚 Available Examples / Доступные примеры / Қолжетімді мысалдар

Each language folder contains the same set of examples:
Каждая языковая папка содержит одинаковый набор примеров:
Әрбір тілдік қалтада бірдей мысалдар жинағы бар:

### Receiver / Приёмник / Қабылдағыш
- `receiverKeyPress` - Detect button press / Обнаружение нажатия / Батырма басуды анықтау
- `receiverKeyHold` - Detect button hold / Обнаружение удержания / Басылып тұрғанын анықтау
- `receiverProtocol-Info` - Protocol information / Информация о протоколе / Хаттама туралы ақпарат
- `receiverProtocol-InfoAll` - Full protocol details / Полная информация о протоколе / Толық хаттама ақпараты
- `receiverSetProtokol` - Custom protocol / Пользовательский протокол / Пайдаланушы хаттамасы

### Transmitter / Передатчик / Таратқыш
- `transmitterWithoutRetries` - Single send / Одиночная отправка / Бір рет жіберу
- `transmitterWithRetries` - Send with repeats / Отправка с повторами / Қайталаумен жіберу
- `transmitterSetProtokol` - Custom protocol / Пользовательский протокол / Пайдаланушы хаттамасы

### Ready-made Remotes / Готовые пульты / Дайын пульттер
- `BlackRemoteControllerKeys` - Black remote (17 buttons) / Чёрный пульт (17 кнопок) / Қара пульт (17 батырма)
- `GrayRemoteControllerKeys` - Gray remote (21 buttons) / Серый пульт (21 кнопка) / Сұр пульт (21 батырма)

---

## 🚀 Quick Start / Быстрый старт / Жылдам бастау

1. **Choose your language** / **Выберите язык** / **Тіліңізді таңдаңыз**
   - English → `en/`
   - Русский → `ru/`
   - Қазақша → `kk/`

2. **Open an example** / **Откройте пример** / **Мысалды ашыңыз**

3. **Upload to Arduino** / **Загрузите в Arduino** / **Arduino-ға жүктеңіз**

4. **Open Serial Monitor** / **Откройте Serial Monitor** / **Serial Monitor-ды ашыңыз**

---

## 🔗 Links / Ссылки / Сілтемелер

- Website / Сайт / Веб-сайт: https://alash-electronics.kz/
- GitHub: https://github.com/Alash-electronics/AlashIRControl
- Documentation / Документация / Құжаттама: [CLAUDE.md](../CLAUDE.md)

---

Made with ❤️ by Alash Electronics
