/*
 * Код использует библиотеку AlashIRControl для управления ИК-передатчиком. 
 * В setup() настраиваются пины для кнопок и инициализируется ИК-передатчик с указанием протокола. 
 * В цикле loop() проверяется нажатие кнопок на пинах 6, 7 и 8, и отправляются соответствующие ИК-коды.
*/

// Библиотека AlashIRControl для работы с ИК приёмопередатчиками разработана https://alash-electronics.kz/
// Для отправки данных предлагаем воспользоваться ИК-передатчиком

#include <AlashIRControlTX.h> // Подключаем библиотеку для работы с ИК-передатчиком
AlashIRControlTX irTransmitter(2); // Объявляем объект irTransmitter, с указанием вывода, к которому подключён ИК-передатчик

void setup() {
  irTransmitter.begin(); // Инициируем работу с ИК-передатчиком
  pinMode(6, INPUT); // Конфигурируем 6 вывод, к которому подключена кнопка, как вход
  pinMode(7, INPUT); // Конфигурируем 7 вывод, к которому подключена кнопка, как вход
  pinMode(8, INPUT); // Конфигурируем 8 вывод, к которому подключена кнопка, как вход
  irTransmitter.protocol("AeQQV~zK]Kp^KJp[@@@@@@@Bp"); // Указываем протокол передачи данных от пульта ELENBERG
}
void loop() {
  if (digitalRead(6)) {
    irTransmitter.send(0x417, true); // Если нажата кнопка на 6 выводе, отправляем сигнал ON/OFF с пакетами повторов
  }
  if (digitalRead(7)) {
    irTransmitter.send(0x425, true); // Если нажата кнопка на 7 выводе, отправляем сигнал VOL- с пакетами повторов
  }
  if (digitalRead(8)) {
    irTransmitter.send(0x427); // Если нажата кнопка на 8 выводе, отправляем сигнал VOL+ без пакетов повторов
  }
}

/*
 * По умолчанию отправляемые данные кодируются длиной паузы.
 * Изменить кодировку и протокол можно функцией protocol().
 * См. пример transmitter_SetProtocol.
 */
