/*
 * Бұл код ИҚ-таратқышты басқару үшін AlashIRControl кітапханасын пайдаланады.
 * setup() ішінде батырма пиндері конфигурацияланады және ИҚ-таратқыш инициализацияланады.
 * loop() циклінде 3, 4 және 5 пиндеріндегі батырмалардың басылуы тексеріледі және сәйкес ИҚ-кодтар жіберіледі.
 * Батырма басылып тұрғанда қайталау пакеттері жіберіледі.
*/
// AlashIRControl кітапханасы ИҚ-қабылдағыштармен жұмыс үшін https://alash-electronics.kz/ дайындалған
// Деректерді жіберу үшін ИҚ-таратқышты пайдалануды ұсынамыз

#include <AlashIRControlTX.h> // ИҚ-таратқышпен жұмыс істеу үшін кітапхананы қосу
AlashIRControlTX irTransmitter(2); // irTransmitter объектісін жариялау, ИҚ-таратқыш қосылған пинді көрсету

void setup() {
  pinMode(3, INPUT); // Батырма қосылған 3-пинді кіріс ретінде конфигурациялау
  pinMode(4, INPUT); // Батырма қосылған 4-пинді кіріс ретінде конфигурациялау
  pinMode(5, INPUT); // Батырма қосылған 5-пинді кіріс ретінде конфигурациялау
  irTransmitter.begin(); // ИҚ-таратқышты инициализациялау
}
void loop() {
  // Егер 3-пинге қосылған батырма басылса, 0x00FFA25D кодын жіберу және басылып тұрғанда қайталау пакеттерін жіберу
  if (digitalRead(3)) {
    irTransmitter.send(0x00FFA25D, true);
  }
  // Егер 4-пинге қосылған батырма басылса, 0x00FF629D кодын жіберу және басылып тұрғанда қайталау пакеттерін жіберу
  if (digitalRead(4)) {
    irTransmitter.send(0x00FF629D, true);
  }
  // Егер 5-пинге қосылған батырма басылса, 0x00FFE21D кодын жіберу және басылып тұрғанда қайталау пакеттерін жіберу
  if (digitalRead(5)) {
    irTransmitter.send(0x00FFE21D, true);
  }
}
/*
 * Әдепкі бойынша, жіберілетін деректер үзіліс ұзындығымен кодталады.
 * protocol() функциясын пайдаланып кодтауды және хаттаманы өзгертуге болады.
 * transmitter_SetProtocol мысалын қараңыз.
 */
