/*
 * Код использует библиотеку AlashIRControl для управления ИК-передатчиком. 
 * В setup() передатчик инициализируется и отправляет код 0x00FFA25D один раз при запуске. 
 * В цикле loop() ничего не выполняется. По умолчанию данные кодируются длиной паузы, 
 * но можно изменить кодировку и протокол с помощью функции protocol().
*/

// Библиотека AlashIRControl для работы с ИК приёмопередатчиками разработана https://alash-electronics.kz/
// Для отправки данных предлагаем воспользоваться ИК-передатчиком

#include <AlashIRControlTX.h> // Подключаем библиотеку для работы с ИК-передатчиком
AlashIRControlTX irTransmitter(10); // Объявляем объект irTransmitter, с указанием вывода, к которому подключён ИК-передатчик

void setup() {
  irTransmitter.begin(); // Инициализация работы с ИК-передатчиком
  irTransmitter.send(0x00FFA25D); // Однократная отправка кода 0x00FFA25D
}
void loop() {} // Пустой цикл loop, Arduino отправит код при включении
/*
 * По умолчанию отправляемые данные кодируются длиной паузы.
 * Изменить кодировку и протокол можно функцией protocol().
 * См. пример transmitterSetProtocol.
 */
