# Examples in English

This folder contains examples of using the AlashIRControl library with comments in English.

## Available Examples

### Receiver
- **receiverKeyPress** - Get code when a button is pressed on the remote
- **receiverKeyHold** - Get code when a button is held on the remote
- **receiverProtocol-Info** - Output information about the received signal protocol
- **receiverProtocol-InfoAll** - Detailed output of all protocol information
- **receiverSetProtokol** - Set a custom receive protocol

### Transmitter
- **transmitterWithoutRetries** - Send IR code without repeats
- **transmitterWithRetries** - Send IR code with repeats when button is held
- **transmitterSetProtokol** - Set a custom transmit protocol

### Examples with Ready-made Remotes
- **BlackRemoteControllerKeys** - Codes for black remote (17 buttons)
- **GrayRemoteControllerKeys** - Codes for gray remote (21 buttons)

## How to Use

1. Open the desired example in Arduino IDE
2. Connect your IR receiver or transmitter to the corresponding pin
3. Upload the sketch to Arduino
4. Open Serial Monitor to view results

## More Information

Visit https://alash-electronics.kz/ for more information and support.
