/*
 * Код использует библиотеку AlashIRControl для управления ИК-передатчиком. 
 * В setup() настраиваются пины для кнопок и инициализируется ИК-передатчик. 
 * В цикле loop() проверяется нажатие кнопок на пинах 3, 4 и 5, и отправляются соответствующие ИК-коды. 
 * При удержании кнопки передаются пакеты повторов.
*/
// Библиотека AlashIRControl для работы с ИК приёмопередатчиками разработана https://alash-electronics.kz/
// Для отправки данных предлагаем воспользоваться ИК-передатчиком

#include <AlashIRControlTX.h> // Подключаем библиотеку для работы с ИК-передатчиком
AlashIRControlTX irTransmitter(2); // Объявляем объект irTransmitter, с указанием вывода, к которому подключён ИК-передатчик

void setup() {
  pinMode(3, INPUT); // Конфигурируем 3 вывод, к которому подключена кнопка, как вход
  pinMode(4, INPUT); // Конфигурируем 4 вывод, к которому подключена кнопка, как вход
  pinMode(5, INPUT); // Конфигурируем 5 вывод, к которому подключена кнопка, как вход
  irTransmitter.begin(); // Инициализация работы с ИК-передатчиком
}
void loop() {
  // Если нажата кнопка, подключённая к 3 выводу, отправляем код 0x00FFA25D и при удержании отправляем пакеты повторов
  if (digitalRead(3)) {
    irTransmitter.send(0x00FFA25D, true);
  }
  // Если нажата кнопка, подключённая к 4 выводу, отправляем код 0x00FF629D и при удержании отправляем пакеты повторов
  if (digitalRead(4)) {
    irTransmitter.send(0x00FF629D, true);
  }
  // Если нажата кнопка, подключённая к 5 выводу, отправляем код 0x00FFE21D и при удержании отправляем пакеты повторов
  if (digitalRead(5)) {
    irTransmitter.send(0x00FFE21D, true);
  }
}
/*
 * По умолчанию отправляемые данные кодируются длиной паузы.
 * Изменить кодировку и протокол можно функцией protocol().
 * См. пример transmitter_SetProtocol.
 */
