/*
 * Бұл код ИҚ-таратқышты басқару үшін AlashIRControl кітапханасын пайдаланады.
 * setup() ішінде таратқыш инициализацияланады және іске қосылғанда 0x00FFA25D кодын бір рет жібереді.
 * loop() циклі ештеңе істемейді. Әдепкі бойынша, деректер үзіліс ұзындығымен кодталады,
 * бірақ protocol() функциясын пайдаланып кодтауды және хаттаманы өзгертуге болады.
*/

// AlashIRControl кітапханасы ИҚ-қабылдағыштармен жұмыс үшін https://alash-electronics.kz/ дайындалған
// Деректерді жіберу үшін ИҚ-таратқышты пайдалануды ұсынамыз

#include <AlashIRControlTX.h> // ИҚ-таратқышпен жұмыс істеу үшін кітапхананы қосу
AlashIRControlTX irTransmitter(10); // irTransmitter объектісін жариялау, ИҚ-таратқыш қосылған пинді көрсету

void setup() {
  irTransmitter.begin(); // ИҚ-таратқышты инициализациялау
  irTransmitter.send(0x00FFA25D); // 0x00FFA25D кодын бір рет жіберу
}
void loop() {} // Бос цикл, Arduino іске қосылғанда кодты жібереді
/*
 * Әдепкі бойынша, жіберілетін деректер үзіліс ұзындығымен кодталады.
 * protocol() функциясын пайдаланып кодтауды және хаттаманы өзгертуге болады.
 * transmitterSetProtocol мысалын қараңыз.
 */
