## AITINKR_SHIELDS

AITinkr Shields are designed to provide an easy-to-use interface for the **AITinkr's ROBOCON MINI** and **Arduino Uno with AITinkr's I/O SHIELDS**. These shields enhance the capabilities of the Arduino, allowing for seamless integration with a wide range of sensors and modules. They mount directly onto the Arduino to save space and simplify connections.

### AITINKR_SHIELD_V1

The AITinkr Shield V1 is designed specifically for the Arduino UNO. It offers the following features:
- 6x 3-PIN Analog inputs
- 3x 4-PIN Analog inputs
- 6x Servo connectors
- 4x 2-PIN BO motor connectors
- 1x Stepper motor connector
- Motor driver
- Bluetooth module connector
- I2C pins
- DC jack for external power supply
- 3-PIN battery connector

### AITINKR_SHIELD_V2

The AITinkr Shield V2 is an upgraded version designed for the Arduino UNO with the following features:
- 7x 3-PIN Analog inputs
- 3x 4-PIN Analog inputs
- 4x Servo connectors
- 4x 2-PIN BO motor connectors
- 1x Stepper motor connector
- Motor driver
- Bluetooth module connector
- I2C pins
- DC jack for external power supply
- 3-PIN battery connector

### AITINKR_SHIELDS_LIBRARY

This library is designed to work seamlessly with the **AITinkr's ROBOCON MINI** and **AITinkr Shields V1 and V2**, which are available on GitHub: [AITinkr Shields GitHub Repository](https://github.com/AITINKR/AITINKR_SHIELDS). The library provides unique functionalities, allowing the shields to be used as add-ons for the Arduino Uno. This makes it easy to connect and code with a wide range of sensors and modules.

## Features

- Control two motors with variable speed and direction.
- Support for three ultrasonic sensors for distance measurement.
- Easy-to-use classes for both analog and digital motor control.
- Simple digital on/off control for channels.
- Customizable motor speed and offset adjustments for balanced movement.

## Recommended Boards

- **AITinkr's ROBOCON MINI**
- **Arduino UNO with AITinkr's I/O Shields**