//==============================================================
// ST7789 LCD Driver Registers
//==============================================================
#define GFX4dESP32_ST7789_READ_DISPLAY_PIXEL_FORMAT     0x0C
#define GFX4dESP32_ST7789_SLEEP_OUT                     0x11
#define GFX4dESP32_ST7789_GAMMA_SET                     0x26
#define GFX4dESP32_ST7789_DISPLAY_OFF                   0x28
#define GFX4dESP32_ST7789_DISPLAY_ON                    0x29
#define GFX4dESP32_ST7789_SET_COLUMN_ADDRESS            0x2A
#define GFX4dESP32_ST7789_SET_PAGE_ADDRESS              0x2B
#define GFX4dESP32_ST7789_WRITE_MEMORY                  0x2C
#define GFX4dESP32_ST7789_READ_MEMORY                   0x2E
#define GFX4dESP32_ST7789_MEMORY_ACCESS_CONTROL         0x36
#define GFX4dESP32_ST7789_WRITE_MEMORY_CONTINUE         0x3C
#define GFX4dESP32_ST7789_READ_MEMORY_CONTINUE          0x3E
#define GFX4dESP32_ST7789_PIXEL_FORMAT_SET              0x3A
#define GFX4dESP32_ST7789_FRAME_RATE_CONTROL            0xB1
#define GFX4dESP32_ST7789_DISPLAY_FUNCTION_CONTROL      0xB6
#define GFX4dESP32_ST7789_POWER_CONTROL_1               0xC0
#define GFX4dESP32_ST7789_POWER_CONTROL_2               0xC1
#define GFX4dESP32_ST7789_VCOM_CONTROL_1                0xC5
#define GFX4dESP32_ST7789_VCOM_CONTROL_2                0xC7
#define GFX4dESP32_ST7789_POWER_CONTROL_A               0xCB
#define GFX4dESP32_ST7789_POWER_CONTROL_B               0xCF
#define GFX4dESP32_ST7789_POSITIVE_GAMMA_CORRECTION     0xE0
#define GFX4dESP32_ST7789_NEGATIVE_GAMMA_CORRECTION     0xE1
#define GFX4dESP32_ST7789_DRIVER_TIMING_CONTROL_A       0xE8
#define GFX4dESP32_ST7789_DRIVER_TIMING_CONTROL_B       0xEA
#define GFX4dESP32_ST7789_POWER_ON_SEQUENCE_CONTROL     0xED
#define GFX4dESP32_ST7789_UNDOCUMENTED_0xEF             0xEF
#define GFX4dESP32_ST7789_ENABLE_3G                     0xF2
#define GFX4dESP32_ST7789_INTERFACE_CONTROL             0xF6
#define GFX4dESP32_ST7789_PUMP_RATIO_CONTROL            0xF7

uint8_t Init_CommandST[160] = {
    3, GFX4dESP32_ST7789_INTERFACE_CONTROL,             0x01, 0x01, 0x00,
    3, GFX4dESP32_ST7789_POWER_CONTROL_B,               0x00, 0xC1, 0x30,
    4, GFX4dESP32_ST7789_POWER_ON_SEQUENCE_CONTROL,     0x64, 0x03, 0x12, 0x81,
    3, GFX4dESP32_ST7789_DRIVER_TIMING_CONTROL_A,       0x85, 0x00, 0x7A,
    5, GFX4dESP32_ST7789_POWER_CONTROL_A,               0x39, 0x2C, 0x00, 0x34, 0x02,
    1, GFX4dESP32_ST7789_PUMP_RATIO_CONTROL,            0x20,
    2, GFX4dESP32_ST7789_DRIVER_TIMING_CONTROL_B,       0x00, 0x00,
    1, GFX4dESP32_ST7789_POWER_CONTROL_1,               0x26,
    1, GFX4dESP32_ST7789_POWER_CONTROL_2,               0x11,
    2, GFX4dESP32_ST7789_VCOM_CONTROL_1,                0x39, 0x37,
    1, GFX4dESP32_ST7789_VCOM_CONTROL_2,                0xA6,
    1, GFX4dESP32_ST7789_MEMORY_ACCESS_CONTROL,         0x08,
    2, GFX4dESP32_ST7789_DISPLAY_FUNCTION_CONTROL,      0x0A, 0x82,     // 0x82 was 0xA2,
    2, GFX4dESP32_ST7789_FRAME_RATE_CONTROL,            0x00, 0x1B,
    1, GFX4dESP32_ST7789_ENABLE_3G,                     0x00,
    1, GFX4dESP32_ST7789_GAMMA_SET,                     0x01,
    1, GFX4dESP32_ST7789_PIXEL_FORMAT_SET,              0x55,
    15, GFX4dESP32_ST7789_POSITIVE_GAMMA_CORRECTION,    0x0f, 0x2D, 0x0E, 0x08, 0x12, 0x0A, 0x3D, 0x95, 0x31, 0x04, 0x10, 0x09, 0x09, 0x0D, 0x00,
    15, GFX4dESP32_ST7789_NEGATIVE_GAMMA_CORRECTION,    0x00, 0x12, 0x17, 0x03, 0x0d, 0x05, 0x2c, 0x44, 0x41, 0x05, 0x0F, 0x0a, 0x30, 0x32, 0x0F,
    0xff
};

//==============================================================
// ILI9341 LCD Driver Registers
//==============================================================
#define GFX4dESP32_ILI9341_READ_DISPLAY_PIXEL_FORMAT    0x0C
#define GFX4dESP32_ILI9341_SLEEP_OUT                    0x11
#define GFX4dESP32_ILI9341_GAMMA_SET                    0x26
#define GFX4dESP32_ILI9341_DISPLAY_OFF                  0x28
#define GFX4dESP32_ILI9341_DISPLAY_ON                   0x29
#define GFX4dESP32_ILI9341_SET_COLUMN_ADDRESS           0x2A
#define GFX4dESP32_ILI9341_SET_PAGE_ADDRESS             0x2B
#define GFX4dESP32_ILI9341_WRITE_MEMORY                 0x2C
#define GFX4dESP32_ILI9341_READ_MEMORY                  0x2E
#define GFX4dESP32_ILI9341_MEMORY_ACCESS_CONTROL        0x36
#define GFX4dESP32_ILI9341_WRITE_MEMORY_CONTINUE        0x3C
#define GFX4dESP32_ILI9341_READ_MEMORY_CONTINUE         0x3E
#define GFX4dESP32_ILI9341_PIXEL_FORMAT_SET             0x3A
#define GFX4dESP32_ILI9341_FRAME_RATE_CONTROL           0xB1
#define GFX4dESP32_ILI9341_DISPLAY_FUNCTION_CONTROL     0xB6
#define GFX4dESP32_ILI9341_POWER_CONTROL_1              0xC0
#define GFX4dESP32_ILI9341_POWER_CONTROL_2              0xC1
#define GFX4dESP32_ILI9341_VCOM_CONTROL_1               0xC5
#define GFX4dESP32_ILI9341_VCOM_CONTROL_2               0xC7
#define GFX4dESP32_ILI9341_POWER_CONTROL_A              0xCB
#define GFX4dESP32_ILI9341_POWER_CONTROL_B              0xCF
#define GFX4dESP32_ILI9341_POSITIVE_GAMMA_CORRECTION    0xE0
#define GFX4dESP32_ILI9341_NEGATIVE_GAMMA_CORRECTION    0xE1
#define GFX4dESP32_ILI9341_DRIVER_TIMING_CONTROL_A      0xE8
#define GFX4dESP32_ILI9341_DRIVER_TIMING_CONTROL_B      0xEA
#define GFX4dESP32_ILI9341_POWER_ON_SEQUENCE_CONTROL    0xED
#define GFX4dESP32_ILI9341_UNDOCUMENTED_0xEF            0xEF
#define GFX4dESP32_ILI9341_ENABLE_3G                    0xF2
#define GFX4dESP32_ILI9341_INTERFACE_CONTROL            0xF6
#define GFX4dESP32_ILI9341_PUMP_RATIO_CONTROL           0xF7

uint8_t Init_Commandili[160] = {
    3, GFX4dESP32_ILI9341_INTERFACE_CONTROL,            0x01, 0x01, 0x00,
    3, GFX4dESP32_ILI9341_POWER_CONTROL_B,              0x00, 0xC1, 0x30,
    4, GFX4dESP32_ILI9341_POWER_ON_SEQUENCE_CONTROL,    0x64, 0x03, 0x12, 0x81,
    3, GFX4dESP32_ILI9341_DRIVER_TIMING_CONTROL_A,      0x85, 0x00, 0x7A,
    5, GFX4dESP32_ILI9341_POWER_CONTROL_A,              0x39, 0x2C, 0x00, 0x34, 0x02,
    1, GFX4dESP32_ILI9341_PUMP_RATIO_CONTROL,           0x20,
    2, GFX4dESP32_ILI9341_DRIVER_TIMING_CONTROL_B,      0x00, 0x00,
    1, GFX4dESP32_ILI9341_POWER_CONTROL_1,              0x26,
    1, GFX4dESP32_ILI9341_POWER_CONTROL_2,              0x11,
    2, GFX4dESP32_ILI9341_VCOM_CONTROL_1,               0x39, 0x37,
    1, GFX4dESP32_ILI9341_VCOM_CONTROL_2,               0xA6,
    1, GFX4dESP32_ILI9341_MEMORY_ACCESS_CONTROL,        0x08,
    2, GFX4dESP32_ILI9341_DISPLAY_FUNCTION_CONTROL,     0x0A, 0x82,     // 0x82 was 0xA2,
    2, GFX4dESP32_ILI9341_FRAME_RATE_CONTROL,           0x00, 0x1B,
    1, GFX4dESP32_ILI9341_ENABLE_3G,                    0x00,
    1, GFX4dESP32_ILI9341_GAMMA_SET,                    0x01,
    1, GFX4dESP32_ILI9341_PIXEL_FORMAT_SET,             0x55,
    15, GFX4dESP32_ILI9341_POSITIVE_GAMMA_CORRECTION,   0x0f, 0x2D, 0x0E, 0x08, 0x12, 0x0A, 0x3D, 0x95, 0x31, 0x04, 0x10, 0x09, 0x09, 0x0D, 0x00,
    15, GFX4dESP32_ILI9341_NEGATIVE_GAMMA_CORRECTION,   0x00, 0x12, 0x17, 0x03, 0x0d, 0x05, 0x2c, 0x44, 0x41, 0x05, 0x0F, 0x0a, 0x30, 0x32, 0x0F,
    0xff 
};
