"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const os = require("os");
const chai_1 = require("chai");
const exec_util_1 = require("../../node/exec-util");
chai_1.use(require('chai-string'));
describe('getExecPath', () => {
    it('should resolve arduino-cli', async () => {
        const actual = await exec_util_1.getExecPath('arduino-cli', onError, 'version');
        const expected = os.platform() === 'win32' ? '\\arduino-cli.exe' : '/arduino-cli';
        chai_1.expect(actual).to.endsWith(expected);
    });
    it('should resolve arduino-language-server', async () => {
        const actual = await exec_util_1.getExecPath('arduino-language-server');
        const expected = os.platform() === 'win32'
            ? '\\arduino-language-server.exe'
            : '/arduino-language-server';
        chai_1.expect(actual).to.endsWith(expected);
    });
    it('should resolve clangd', async () => {
        const actual = await exec_util_1.getExecPath('clangd', onError, '--version');
        const expected = os.platform() === 'win32' ? '\\clangd.exe' : '/clangd';
        chai_1.expect(actual).to.endsWith(expected);
    });
    function onError(error) {
        console.error(error);
    }
});
//# sourceMappingURL=exec-util.test.js.map