"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.anInstalledPackage = exports.aPackage = exports.anotherBoardConfig = exports.anotherPort = exports.anotherBoard = exports.aBoardConfig = exports.aPort = exports.aBoard = void 0;
exports.aBoard = {
    fqbn: 'some:board:fqbn',
    name: 'Some Arduino Board',
    port: {
        id: '/lol/port1234|serial',
        address: '/lol/port1234',
        addressLabel: '/lol/port1234',
        protocol: 'serial',
        protocolLabel: 'Serial Port (USB)',
    },
};
exports.aPort = {
    id: exports.aBoard.port.id,
    address: exports.aBoard.port.address,
    addressLabel: exports.aBoard.port.addressLabel,
    protocol: exports.aBoard.port.protocol,
    protocolLabel: exports.aBoard.port.protocolLabel,
};
exports.aBoardConfig = {
    selectedBoard: exports.aBoard,
    selectedPort: exports.aPort,
};
exports.anotherBoard = {
    fqbn: 'another:board:fqbn',
    name: 'Another Arduino Board',
    port: {
        id: '/kek/port5678|serial',
        address: '/kek/port5678',
        addressLabel: '/kek/port5678',
        protocol: 'serial',
        protocolLabel: 'Serial Port (USB)',
    },
};
exports.anotherPort = {
    id: exports.anotherBoard.port.id,
    address: exports.anotherBoard.port.address,
    addressLabel: exports.anotherBoard.port.addressLabel,
    protocol: exports.anotherBoard.port.protocol,
    protocolLabel: exports.anotherBoard.port.protocolLabel,
};
exports.anotherBoardConfig = {
    selectedBoard: exports.anotherBoard,
    selectedPort: exports.anotherPort,
};
exports.aPackage = {
    author: 'someAuthor',
    availableVersions: ['some.ver.sion', 'some.other.version'],
    boards: [exports.aBoard],
    deprecated: false,
    description: 'Some Arduino Board, Some Other Arduino Board',
    id: 'some:arduinoCoreId',
    installable: true,
    moreInfoLink: 'http://www.some-url.lol/',
    name: 'Some Arduino Package',
    summary: 'Boards included in this package:',
};
exports.anInstalledPackage = Object.assign(Object.assign({}, exports.aPackage), { installedVersion: 'some.ver.sion' });
//# sourceMappingURL=boards.js.map