"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@theia/core");
const inversify_1 = require("inversify");
const WebSocket = require("ws");
let WebSocketServiceImpl = class WebSocketServiceImpl {
    constructor() {
        this.onMessage = new core_1.Emitter();
        this.onMessageReceived = this.onMessage.event;
        this.onConnectedClients = new core_1.Emitter();
        this.onClientsNumberChanged = this.onConnectedClients.event;
        this.wsClients = [];
        this.server = new WebSocket.Server({ port: 0 });
        const addClient = this.addClient.bind(this);
        this.server.on('connection', addClient);
    }
    addClient(ws) {
        this.wsClients.push(ws);
        this.onConnectedClients.fire(this.wsClients.length);
        ws.onclose = () => {
            this.wsClients.splice(this.wsClients.indexOf(ws), 1);
            this.onConnectedClients.fire(this.wsClients.length);
        };
        ws.onmessage = (res) => {
            this.onMessage.fire(res.data.toString());
        };
    }
    getConnectedClientsNumber() {
        return this.wsClients.length;
    }
    getAddress() {
        return this.server.address();
    }
    sendMessage(message) {
        this.wsClients.forEach((w) => {
            try {
                w.send(message);
            }
            catch (_a) {
                w.close();
            }
        });
    }
};
WebSocketServiceImpl = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], WebSocketServiceImpl);
exports.default = WebSocketServiceImpl;
//# sourceMappingURL=web-socket-service-impl.js.map