"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultWorkspaceServer = void 0;
const inversify_1 = require("inversify");
const logger_1 = require("@theia/core/lib/common/logger");
const default_workspace_server_1 = require("@theia/workspace/lib/node/default-workspace-server");
const config_service_1 = require("../../../common/protocol/config-service");
let DefaultWorkspaceServer = class DefaultWorkspaceServer extends default_workspace_server_1.DefaultWorkspaceServer {
    async getWorkspaceURIFromCli() {
        try {
            const config = await this.configService.getConfiguration();
            return config.sketchDirUri;
        }
        catch (err) {
            this.logger.error(`Failed to determine the sketch directory: ${err}`);
            return super.getWorkspaceURIFromCli();
        }
    }
};
__decorate([
    inversify_1.inject(config_service_1.ConfigService),
    __metadata("design:type", Object)
], DefaultWorkspaceServer.prototype, "configService", void 0);
__decorate([
    inversify_1.inject(logger_1.ILogger),
    __metadata("design:type", Object)
], DefaultWorkspaceServer.prototype, "logger", void 0);
DefaultWorkspaceServer = __decorate([
    inversify_1.injectable()
], DefaultWorkspaceServer);
exports.DefaultWorkspaceServer = DefaultWorkspaceServer;
//# sourceMappingURL=default-workspace-server.js.map