"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGitInit = void 0;
const inversify_1 = require("inversify");
const find_git_exec_1 = require("find-git-exec");
const path_1 = require("path");
const fs_extra_1 = require("fs-extra");
const disposable_1 = require("@theia/core/lib/common/disposable");
let DefaultGitInit = class DefaultGitInit {
    constructor() {
        this.toDispose = new disposable_1.DisposableCollection();
    }
    async init() {
        const { env } = process;
        try {
            const { execPath, path, version } = await find_git_exec_1.default();
            if (!!execPath && !!path && !!version) {
                const dir = path_1.dirname(path_1.dirname(path));
                const [execPathOk, pathOk, dirOk] = await Promise.all([
                    fs_extra_1.pathExists(execPath),
                    fs_extra_1.pathExists(path),
                    fs_extra_1.pathExists(dir),
                ]);
                if (execPathOk && pathOk && dirOk) {
                    if (typeof env.LOCAL_GIT_DIRECTORY !== 'undefined' &&
                        env.LOCAL_GIT_DIRECTORY !== dir) {
                        console.error(`Misconfigured env.LOCAL_GIT_DIRECTORY: ${env.LOCAL_GIT_DIRECTORY}. dir was: ${dir}`);
                        return;
                    }
                    if (typeof env.GIT_EXEC_PATH !== 'undefined' &&
                        env.GIT_EXEC_PATH !== execPath) {
                        console.error(`Misconfigured env.GIT_EXEC_PATH: ${env.GIT_EXEC_PATH}. execPath was: ${execPath}`);
                        return;
                    }
                    process.env.LOCAL_GIT_DIRECTORY = dir;
                    process.env.GIT_EXEC_PATH = execPath;
                    console.info(`Using Git [${version}] from the PATH. (${path})`);
                    return;
                }
            }
        }
        catch (err) {
            console.error(err);
        }
    }
    dispose() {
        this.toDispose.dispose();
    }
};
DefaultGitInit = __decorate([
    inversify_1.injectable()
], DefaultGitInit);
exports.DefaultGitInit = DefaultGitInit;
//# sourceMappingURL=git-init.js.map