"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationServiceServerImpl = void 0;
const inversify_1 = require("inversify");
let NotificationServiceServerImpl = class NotificationServiceServerImpl {
    constructor() {
        this.clients = [];
    }
    notifyIndexUpdated() {
        this.clients.forEach((client) => client.notifyIndexUpdated());
    }
    notifyDaemonStarted() {
        this.clients.forEach((client) => client.notifyDaemonStarted());
    }
    notifyDaemonStopped() {
        this.clients.forEach((client) => client.notifyDaemonStopped());
    }
    notifyPlatformInstalled(event) {
        this.clients.forEach((client) => client.notifyPlatformInstalled(event));
    }
    notifyPlatformUninstalled(event) {
        this.clients.forEach((client) => client.notifyPlatformUninstalled(event));
    }
    notifyLibraryInstalled(event) {
        this.clients.forEach((client) => client.notifyLibraryInstalled(event));
    }
    notifyLibraryUninstalled(event) {
        this.clients.forEach((client) => client.notifyLibraryUninstalled(event));
    }
    notifyAttachedBoardsChanged(event) {
        this.clients.forEach((client) => client.notifyAttachedBoardsChanged(event));
    }
    notifyConfigChanged(event) {
        this.clients.forEach((client) => client.notifyConfigChanged(event));
    }
    notifyRecentSketchesChanged(event) {
        this.clients.forEach((client) => client.notifyRecentSketchesChanged(event));
    }
    setClient(client) {
        this.clients.push(client);
    }
    disposeClient(client) {
        const index = this.clients.indexOf(client);
        if (index === -1) {
            console.warn('Could not dispose notification service client. It was not registered.');
            return;
        }
        this.clients.splice(index, 1);
    }
    dispose() {
        for (const client of this.clients) {
            this.disposeClient(client);
        }
        this.clients.length = 0;
    }
};
NotificationServiceServerImpl = __decorate([
    inversify_1.injectable()
], NotificationServiceServerImpl);
exports.NotificationServiceServerImpl = NotificationServiceServerImpl;
//# sourceMappingURL=notification-service-server.js.map