"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstallWithProgress = void 0;
var InstallWithProgress;
(function (InstallWithProgress) {
    function createDataCallback({ responseService, progressId, }) {
        let localFile = '';
        let localTotalSize = Number.NaN;
        return (response) => {
            const download = response.getProgress
                ? response.getProgress()
                : undefined;
            const task = response.getTaskProgress();
            if (!download && !task) {
                throw new Error("Implementation error. Neither 'download' nor 'task' is available.");
            }
            if (task && download) {
                throw new Error("Implementation error. Both 'download' and 'task' are available.");
            }
            if (task) {
                const message = task.getName() || task.getMessage();
                if (message) {
                    if (progressId) {
                        responseService.reportProgress({
                            progressId,
                            message,
                            work: { done: Number.NaN, total: Number.NaN },
                        });
                    }
                    responseService.appendToOutput({ chunk: `${message}\n` });
                }
            }
            else if (download) {
                if (download.getFile() && !localFile) {
                    localFile = download.getFile();
                }
                if (download.getTotalSize() > 0 && Number.isNaN(localTotalSize)) {
                    localTotalSize = download.getTotalSize();
                }
                // This happens only once per file download.
                if (download.getTotalSize() && localFile) {
                    responseService.appendToOutput({ chunk: `${localFile}\n` });
                }
                if (progressId && localFile) {
                    let work = undefined;
                    if (download.getDownloaded() > 0 && !Number.isNaN(localTotalSize)) {
                        work = {
                            total: localTotalSize,
                            done: download.getDownloaded(),
                        };
                    }
                    responseService.reportProgress({
                        progressId,
                        message: `Downloading ${localFile}`,
                        work,
                    });
                }
                if (download.getCompleted()) {
                    // Discard local state.
                    if (progressId && !Number.isNaN(localTotalSize)) {
                        responseService.reportProgress({
                            progressId,
                            message: '',
                            work: { done: Number.NaN, total: Number.NaN },
                        });
                    }
                    localFile = '';
                    localTotalSize = Number.NaN;
                }
            }
        };
    }
    InstallWithProgress.createDataCallback = createDataCallback;
})(InstallWithProgress = exports.InstallWithProgress || (exports.InstallWithProgress = {}));
//# sourceMappingURL=grpc-installable.js.map