"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GrpcClientProvider = void 0;
const inversify_1 = require("inversify");
const logger_1 = require("@theia/core/lib/common/logger");
const config_service_impl_1 = require("./config-service-impl");
const arduino_daemon_impl_1 = require("./arduino-daemon-impl");
let GrpcClientProvider = class GrpcClientProvider {
    init() {
        const updateClient = () => {
            this.reconcileClient();
        };
        this.configService.onConfigChange(updateClient);
        this.daemon.ready.then(updateClient);
        this.daemon.onDaemonStopped(() => {
            if (this._client && !(this._client instanceof Error)) {
                this.close(this._client);
            }
            this._client = undefined;
            this._port = undefined;
        });
    }
    async client() {
        try {
            await this.daemon.ready;
            return this._client;
        }
        catch (error) {
            return error;
        }
    }
    async reconcileClient() {
        const port = await this.daemon.getPort();
        if (this._port === port) {
            return; // Nothing to do.
        }
        this._port = port;
        if (this._client && !(this._client instanceof Error)) {
            this.close(this._client);
            this._client = undefined;
        }
        if (this._port) {
            try {
                const client = await this.createClient(this._port);
                this._client = client;
            }
            catch (error) {
                this.logger.error('Could not create client for gRPC.', error);
                this._client = error;
            }
        }
    }
    get channelOptions() {
        const pjson = require('../../package.json') || { version: '0.0.0' };
        return {
            'grpc.max_send_message_length': 512 * 1024 * 1024,
            'grpc.max_receive_message_length': 512 * 1024 * 1024,
            'grpc.primary_user_agent': `arduino-ide/${pjson.version}`,
        };
    }
};
__decorate([
    inversify_1.inject(logger_1.ILogger),
    __metadata("design:type", Object)
], GrpcClientProvider.prototype, "logger", void 0);
__decorate([
    inversify_1.inject(arduino_daemon_impl_1.ArduinoDaemonImpl),
    __metadata("design:type", arduino_daemon_impl_1.ArduinoDaemonImpl)
], GrpcClientProvider.prototype, "daemon", void 0);
__decorate([
    inversify_1.inject(config_service_impl_1.ConfigServiceImpl),
    __metadata("design:type", config_service_impl_1.ConfigServiceImpl)
], GrpcClientProvider.prototype, "configService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], GrpcClientProvider.prototype, "init", null);
GrpcClientProvider = __decorate([
    inversify_1.injectable()
], GrpcClientProvider);
exports.GrpcClientProvider = GrpcClientProvider;
//# sourceMappingURL=grpc-client-provider.js.map