"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecutableServiceImpl = void 0;
const inversify_1 = require("inversify");
const logger_1 = require("@theia/core/lib/common/logger");
const file_uri_1 = require("@theia/core/lib/node/file-uri");
const exec_util_1 = require("./exec-util");
let ExecutableServiceImpl = class ExecutableServiceImpl {
    async list() {
        const [ls, clangd, cli, fwuploader] = await Promise.all([
            exec_util_1.getExecPath('arduino-language-server', this.onError.bind(this)),
            exec_util_1.getExecPath('clangd', this.onError.bind(this), undefined),
            exec_util_1.getExecPath('arduino-cli', this.onError.bind(this)),
            exec_util_1.getExecPath('arduino-fwuploader', this.onError.bind(this)),
        ]);
        return {
            clangdUri: file_uri_1.FileUri.create(clangd).toString(),
            cliUri: file_uri_1.FileUri.create(cli).toString(),
            lsUri: file_uri_1.FileUri.create(ls).toString(),
            fwuploaderUri: file_uri_1.FileUri.create(fwuploader).toString(),
        };
    }
    onError(error) {
        this.logger.error(error);
    }
};
__decorate([
    inversify_1.inject(logger_1.ILogger),
    __metadata("design:type", Object)
], ExecutableServiceImpl.prototype, "logger", void 0);
ExecutableServiceImpl = __decorate([
    inversify_1.injectable()
], ExecutableServiceImpl);
exports.ExecutableServiceImpl = ExecutableServiceImpl;
//# sourceMappingURL=executable-service-impl.js.map