"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExamplesServiceImpl = void 0;
const inversify_1 = require("inversify");
const path_1 = require("path");
const fs = require("fs");
const util_1 = require("util");
const file_uri_1 = require("@theia/core/lib/node/file-uri");
const objects_1 = require("@theia/core/lib/common/objects");
const sketches_service_impl_1 = require("./sketches-service-impl");
const protocol_1 = require("../common/protocol");
const config_service_impl_1 = require("./config-service-impl");
let ExamplesServiceImpl = class ExamplesServiceImpl {
    init() {
        this.builtIns();
    }
    async builtIns() {
        if (this._all) {
            return this._all;
        }
        const exampleRootPath = path_1.join(__dirname, '..', '..', 'Examples');
        const exampleNames = await util_1.promisify(fs.readdir)(exampleRootPath);
        this._all = await Promise.all(exampleNames
            .map((name) => path_1.join(exampleRootPath, name))
            .map((path) => this.load(path)));
        return this._all;
    }
    // TODO: decide whether it makes sense to cache them. Keys should be: `fqbn` + version of containing core/library.
    async installed({ fqbn }) {
        const user = [];
        const current = [];
        const any = [];
        const packages = await this.libraryService.list({
            fqbn,
        });
        for (const pkg of packages) {
            const container = await this.tryGroupExamples(pkg);
            const { location } = pkg;
            if (location === protocol_1.LibraryLocation.USER) {
                user.push(container);
            }
            else if (location === protocol_1.LibraryLocation.PLATFORM_BUILTIN ||
                protocol_1.LibraryLocation.REFERENCED_PLATFORM_BUILTIN) {
                current.push(container);
            }
            else {
                any.push(container);
            }
        }
        return { user, current, any };
    }
    /**
     * The CLI provides direct FS paths to the examples so that menus and menu groups cannot be built for the UI by traversing the
     * folder hierarchy. This method tries to workaround it by falling back to the `installDirUri` and manually creating the
     * location of the examples. Otherwise it creates the example container from the direct examples FS paths.
     */
    async tryGroupExamples({ label, exampleUris, installDirUri, }) {
        const paths = exampleUris.map((uri) => file_uri_1.FileUri.fsPath(uri));
        if (installDirUri) {
            for (const example of [
                'example',
                'Example',
                'EXAMPLE',
                'examples',
                'Examples',
                'EXAMPLES',
            ]) {
                const examplesPath = path_1.join(file_uri_1.FileUri.fsPath(installDirUri), example);
                const exists = await util_1.promisify(fs.exists)(examplesPath);
                const isDir = exists && (await util_1.promisify(fs.lstat)(examplesPath)).isDirectory();
                if (isDir) {
                    const fileNames = await util_1.promisify(fs.readdir)(examplesPath);
                    const children = [];
                    const sketches = [];
                    for (const fileName of fileNames) {
                        const subPath = path_1.join(examplesPath, fileName);
                        const subIsDir = (await util_1.promisify(fs.lstat)(subPath)).isDirectory();
                        if (subIsDir) {
                            const sketch = await this.tryLoadSketch(subPath);
                            if (!sketch) {
                                const container = await this.load(subPath);
                                if (container.children.length || container.sketches.length) {
                                    children.push(container);
                                }
                            }
                            else {
                                sketches.push(sketch);
                            }
                        }
                    }
                    return {
                        label,
                        children,
                        sketches,
                    };
                }
            }
        }
        const sketches = await Promise.all(paths.map((path) => this.tryLoadSketch(path)));
        return {
            label,
            children: [],
            sketches: sketches.filter(objects_1.notEmpty),
        };
    }
    // Built-ins are included inside the IDE.
    async load(path) {
        if (!(await util_1.promisify(fs.exists)(path))) {
            throw new Error('Examples are not available');
        }
        const stat = await util_1.promisify(fs.stat)(path);
        if (!stat.isDirectory) {
            throw new Error(`${path} is not a directory.`);
        }
        const names = await util_1.promisify(fs.readdir)(path);
        const sketches = [];
        const children = [];
        for (const p of names.map((name) => path_1.join(path, name))) {
            const stat = await util_1.promisify(fs.stat)(p);
            if (stat.isDirectory()) {
                const sketch = await this.tryLoadSketch(p);
                if (sketch) {
                    sketches.push(sketch);
                }
                else {
                    const child = await this.load(p);
                    children.push(child);
                }
            }
        }
        const label = path_1.basename(path);
        return {
            label,
            children,
            sketches,
        };
    }
    async group(paths) {
        const map = new Map();
        for (const path of paths) {
            const stat = await util_1.promisify(fs.stat)(path);
            map.set(path, stat);
        }
        return map;
    }
    async tryLoadSketch(path) {
        try {
            const sketch = await this.sketchesService.loadSketch(file_uri_1.FileUri.create(path).toString());
            return sketch;
        }
        catch (_a) {
            return undefined;
        }
    }
};
__decorate([
    inversify_1.inject(sketches_service_impl_1.SketchesServiceImpl),
    __metadata("design:type", sketches_service_impl_1.SketchesServiceImpl)
], ExamplesServiceImpl.prototype, "sketchesService", void 0);
__decorate([
    inversify_1.inject(protocol_1.LibraryService),
    __metadata("design:type", Object)
], ExamplesServiceImpl.prototype, "libraryService", void 0);
__decorate([
    inversify_1.inject(config_service_impl_1.ConfigServiceImpl),
    __metadata("design:type", config_service_impl_1.ConfigServiceImpl)
], ExamplesServiceImpl.prototype, "configService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ExamplesServiceImpl.prototype, "init", null);
ExamplesServiceImpl = __decorate([
    inversify_1.injectable()
], ExamplesServiceImpl);
exports.ExamplesServiceImpl = ExamplesServiceImpl;
//# sourceMappingURL=examples-service-impl.js.map