"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CoreServiceImpl = void 0;
const file_uri_1 = require("@theia/core/lib/node/file-uri");
const inversify_1 = require("inversify");
const path_1 = require("path");
const wrappers_pb_1 = require("google-protobuf/google/protobuf/wrappers_pb");
const compile_pb_1 = require("./cli-protocol/cc/arduino/cli/commands/v1/compile_pb");
const core_client_provider_1 = require("./core-client-provider");
const upload_pb_1 = require("./cli-protocol/cc/arduino/cli/commands/v1/upload_pb");
const response_service_1 = require("../common/protocol/response-service");
const protocol_1 = require("../common/protocol");
const utils_1 = require("../common/utils");
const port_pb_1 = require("./cli-protocol/cc/arduino/cli/commands/v1/port_pb");
const core_1 = require("@theia/core");
const serial_service_1 = require("./../common/protocol/serial-service");
let CoreServiceImpl = class CoreServiceImpl extends core_client_provider_1.CoreClientAware {
    constructor() {
        super(...arguments);
        this.uploading = false;
    }
    async compile(options) {
        const { sketchUri, fqbn, compilerWarnings } = options;
        const sketchPath = file_uri_1.FileUri.fsPath(sketchUri);
        await this.coreClientProvider.initialized;
        const coreClient = await this.coreClient();
        const { client, instance } = coreClient;
        const compileReq = new compile_pb_1.CompileRequest();
        compileReq.setInstance(instance);
        compileReq.setSketchPath(sketchPath);
        if (fqbn) {
            compileReq.setFqbn(fqbn);
        }
        if (compilerWarnings) {
            compileReq.setWarnings(compilerWarnings.toLowerCase());
        }
        compileReq.setOptimizeForDebug(options.optimizeForDebug);
        compileReq.setPreprocess(false);
        compileReq.setVerbose(options.verbose);
        compileReq.setQuiet(false);
        if (typeof options.exportBinaries === 'boolean') {
            const exportBinaries = new wrappers_pb_1.BoolValue();
            exportBinaries.setValue(options.exportBinaries);
            compileReq.setExportBinaries(exportBinaries);
        }
        this.mergeSourceOverrides(compileReq, options);
        const result = client.compile(compileReq);
        try {
            await new Promise((resolve, reject) => {
                result.on('data', (cr) => {
                    this.responseService.appendToOutput({
                        chunk: Buffer.from(cr.getOutStream_asU8()).toString(),
                    });
                    this.responseService.appendToOutput({
                        chunk: Buffer.from(cr.getErrStream_asU8()).toString(),
                    });
                });
                result.on('error', (error) => reject(error));
                result.on('end', () => resolve());
            });
            this.responseService.appendToOutput({
                chunk: '\n--------------------------\nCompilation complete.\n',
            });
        }
        catch (e) {
            const errorMessage = core_1.nls.localize('arduino/compile/error', 'Compilation error: {0}', e.details);
            this.responseService.appendToOutput({
                chunk: `${errorMessage}\n`,
                severity: 'error',
            });
            throw new Error(errorMessage);
        }
    }
    async upload(options) {
        await this.doUpload(options, () => new upload_pb_1.UploadRequest(), (client, req) => client.upload(req));
    }
    async uploadUsingProgrammer(options) {
        await this.doUpload(options, () => new upload_pb_1.UploadUsingProgrammerRequest(), (client, req) => client.uploadUsingProgrammer(req), 'upload using programmer');
    }
    isUploading() {
        return Promise.resolve(this.uploading);
    }
    async doUpload(options, requestProvider, 
    // tslint:disable-next-line:max-line-length
    responseHandler, task = 'upload') {
        await this.compile(Object.assign(options, { exportBinaries: false }));
        this.uploading = true;
        this.serialService.uploadInProgress = true;
        await this.serialService.disconnect();
        const { sketchUri, fqbn, port, programmer } = options;
        const sketchPath = file_uri_1.FileUri.fsPath(sketchUri);
        await this.coreClientProvider.initialized;
        const coreClient = await this.coreClient();
        const { client, instance } = coreClient;
        const req = requestProvider();
        req.setInstance(instance);
        req.setSketchPath(sketchPath);
        if (fqbn) {
            req.setFqbn(fqbn);
        }
        const p = new port_pb_1.Port();
        if (port) {
            p.setAddress(port.address);
            p.setLabel(port.addressLabel);
            p.setProtocol(port.protocol);
            p.setProtocolLabel(port.protocolLabel);
        }
        req.setPort(p);
        if (programmer) {
            req.setProgrammer(programmer.id);
        }
        req.setVerbose(options.verbose);
        req.setVerify(options.verify);
        options.userFields.forEach((e) => {
            req.getUserFieldsMap().set(e.name, e.value);
        });
        const result = responseHandler(client, req);
        try {
            await new Promise((resolve, reject) => {
                result.on('data', (resp) => {
                    this.responseService.appendToOutput({
                        chunk: Buffer.from(resp.getOutStream_asU8()).toString(),
                    });
                    this.responseService.appendToOutput({
                        chunk: Buffer.from(resp.getErrStream_asU8()).toString(),
                    });
                });
                result.on('error', (error) => reject(error));
                result.on('end', () => resolve());
            });
            this.responseService.appendToOutput({
                chunk: '\n--------------------------\n' +
                    utils_1.firstToLowerCase(task) +
                    ' complete.\n',
            });
        }
        catch (e) {
            const errorMessage = core_1.nls.localize('arduino/upload/error', '{0} error: {1}', utils_1.firstToUpperCase(task), e.details);
            this.responseService.appendToOutput({
                chunk: `${errorMessage}\n`,
                severity: 'error',
            });
            throw new Error(errorMessage);
        }
        finally {
            this.uploading = false;
            this.serialService.uploadInProgress = false;
        }
    }
    async burnBootloader(options) {
        this.uploading = true;
        this.serialService.uploadInProgress = true;
        await this.serialService.disconnect();
        await this.coreClientProvider.initialized;
        const coreClient = await this.coreClient();
        const { client, instance } = coreClient;
        const { fqbn, port, programmer } = options;
        const burnReq = new upload_pb_1.BurnBootloaderRequest();
        burnReq.setInstance(instance);
        if (fqbn) {
            burnReq.setFqbn(fqbn);
        }
        const p = new port_pb_1.Port();
        if (port) {
            p.setAddress(port.address);
            p.setLabel(port.addressLabel);
            p.setProtocol(port.protocol);
            p.setProtocolLabel(port.protocolLabel);
        }
        burnReq.setPort(p);
        if (programmer) {
            burnReq.setProgrammer(programmer.id);
        }
        burnReq.setVerify(options.verify);
        burnReq.setVerbose(options.verbose);
        const result = client.burnBootloader(burnReq);
        try {
            await new Promise((resolve, reject) => {
                result.on('data', (resp) => {
                    this.responseService.appendToOutput({
                        chunk: Buffer.from(resp.getOutStream_asU8()).toString(),
                    });
                    this.responseService.appendToOutput({
                        chunk: Buffer.from(resp.getErrStream_asU8()).toString(),
                    });
                });
                result.on('error', (error) => reject(error));
                result.on('end', () => resolve());
            });
        }
        catch (e) {
            const errorMessage = core_1.nls.localize('arduino/burnBootloader/error', 'Error while burning the bootloader: {0}', e.details);
            this.responseService.appendToOutput({
                chunk: `${errorMessage}\n`,
                severity: 'error',
            });
            throw new Error(errorMessage);
        }
        finally {
            this.uploading = false;
            this.serialService.uploadInProgress = false;
        }
    }
    mergeSourceOverrides(req, options) {
        const sketchPath = file_uri_1.FileUri.fsPath(options.sketchUri);
        for (const uri of Object.keys(options.sourceOverride)) {
            const content = options.sourceOverride[uri];
            if (content) {
                const relativePath = path_1.relative(sketchPath, file_uri_1.FileUri.fsPath(uri));
                req.getSourceOverrideMap().set(relativePath, content);
            }
        }
    }
};
__decorate([
    inversify_1.inject(response_service_1.ResponseService),
    __metadata("design:type", Object)
], CoreServiceImpl.prototype, "responseService", void 0);
__decorate([
    inversify_1.inject(protocol_1.NotificationServiceServer),
    __metadata("design:type", Object)
], CoreServiceImpl.prototype, "notificationService", void 0);
__decorate([
    inversify_1.inject(serial_service_1.SerialService),
    __metadata("design:type", Object)
], CoreServiceImpl.prototype, "serialService", void 0);
CoreServiceImpl = __decorate([
    inversify_1.injectable()
], CoreServiceImpl);
exports.CoreServiceImpl = CoreServiceImpl;
//# sourceMappingURL=core-service-impl.js.map