"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CoreClientAware = exports.CoreClientProvider = void 0;
const grpc = require("@grpc/grpc-js");
const inversify_1 = require("inversify");
const event_1 = require("@theia/core/lib/common/event");
const grpc_client_provider_1 = require("./grpc-client-provider");
const commands_pb_1 = require("./cli-protocol/cc/arduino/cli/commands/v1/commands_pb");
const commandsGrpcPb = require("./cli-protocol/cc/arduino/cli/commands/v1/commands_grpc_pb");
const protocol_1 = require("../common/protocol");
const promise_util_1 = require("@theia/core/lib/common/promise-util");
let CoreClientProvider = class CoreClientProvider extends grpc_client_provider_1.GrpcClientProvider {
    constructor() {
        super(...arguments);
        this.onClientReadyEmitter = new event_1.Emitter();
        this._created = new promise_util_1.Deferred();
        this._initialized = new promise_util_1.Deferred();
    }
    get created() {
        return this._created.promise;
    }
    get initialized() {
        return this._initialized.promise;
    }
    get onClientReady() {
        return this.onClientReadyEmitter.event;
    }
    close(client) {
        client.client.close();
        this._created.reject();
        this._initialized.reject();
        this._created = new promise_util_1.Deferred();
        this._initialized = new promise_util_1.Deferred();
    }
    async reconcileClient() {
        const port = await this.daemon.getPort();
        if (port && port === this._port) {
            // No need to create a new gRPC client, but we have to update the indexes.
            if (this._client && !(this._client instanceof Error)) {
                await this.updateIndexes(this._client);
                this.onClientReadyEmitter.fire();
            }
        }
        else {
            await super.reconcileClient();
            this.onClientReadyEmitter.fire();
        }
    }
    async init() {
        this.daemon.ready.then(async () => {
            // First create the client and the instance synchronously
            // and notify client is ready.
            // TODO: Creation failure should probably be handled here
            await this.reconcileClient().then(() => {
                this._created.resolve();
            });
            // If client has been created correctly update indexes and initialize
            // its instance by loading platforms and cores.
            if (this._client && !(this._client instanceof Error)) {
                await this.updateIndexes(this._client)
                    .then(this.initInstance)
                    .then(() => {
                    this._initialized.resolve();
                });
            }
        });
        this.daemon.onDaemonStopped(() => {
            if (this._client && !(this._client instanceof Error)) {
                this.close(this._client);
            }
            this._client = undefined;
            this._port = undefined;
        });
    }
    async createClient(port) {
        // https://github.com/agreatfool/grpc_tools_node_protoc_ts/blob/master/doc/grpcjs_support.md#usage
        const ArduinoCoreServiceClient = grpc.makeClientConstructor(
        // @ts-expect-error: ignore
        commandsGrpcPb['cc.arduino.cli.commands.v1.ArduinoCoreService'], 'ArduinoCoreServiceService');
        const client = new ArduinoCoreServiceClient(`localhost:${port}`, grpc.credentials.createInsecure(), this.channelOptions);
        const createRes = await new Promise((resolve, reject) => {
            client.create(new commands_pb_1.CreateRequest(), (err, res) => {
                if (err) {
                    reject(err);
                    return;
                }
                resolve(res);
            });
        });
        const instance = createRes.getInstance();
        if (!instance) {
            throw new Error('Could not retrieve instance from the initialize response.');
        }
        return { instance, client };
    }
    async initInstance({ client, instance, }) {
        const initReq = new commands_pb_1.InitRequest();
        initReq.setInstance(instance);
        await new Promise((resolve, reject) => {
            const stream = client.init(initReq);
            stream.on('data', (res) => {
                const progress = res.getInitProgress();
                if (progress) {
                    const downloadProgress = progress.getDownloadProgress();
                    if (downloadProgress && downloadProgress.getCompleted()) {
                        const file = downloadProgress.getFile();
                        console.log(`Downloaded ${file}`);
                    }
                    const taskProgress = progress.getTaskProgress();
                    if (taskProgress && taskProgress.getCompleted()) {
                        const name = taskProgress.getName();
                        console.log(`Completed ${name}`);
                    }
                }
                const err = res.getError();
                if (err) {
                    console.error(err.getMessage());
                }
            });
            stream.on('error', (err) => reject(err));
            stream.on('end', resolve);
        });
    }
    async updateIndexes({ client, instance, }) {
        // in a separate promise, try and update the index
        let indexUpdateSucceeded = true;
        for (let i = 0; i < 10; i++) {
            try {
                await this.updateIndex({ client, instance });
                indexUpdateSucceeded = true;
                break;
            }
            catch (e) {
                console.error(`Error while updating index in attempt ${i}.`, e);
            }
        }
        if (!indexUpdateSucceeded) {
            console.error('Could not update the index. Please restart to try again.');
        }
        let libIndexUpdateSucceeded = true;
        for (let i = 0; i < 10; i++) {
            try {
                await this.updateLibraryIndex({ client, instance });
                libIndexUpdateSucceeded = true;
                break;
            }
            catch (e) {
                console.error(`Error while updating library index in attempt ${i}.`, e);
            }
        }
        if (!libIndexUpdateSucceeded) {
            console.error('Could not update the library index. Please restart to try again.');
        }
        if (indexUpdateSucceeded && libIndexUpdateSucceeded) {
            this.notificationService.notifyIndexUpdated();
        }
        return { client, instance };
    }
    async updateLibraryIndex({ client, instance, }) {
        const req = new commands_pb_1.UpdateLibrariesIndexRequest();
        req.setInstance(instance);
        const resp = client.updateLibrariesIndex(req);
        let file;
        resp.on('data', (data) => {
            const progress = data.getDownloadProgress();
            if (progress) {
                if (!file && progress.getFile()) {
                    file = `${progress.getFile()}`;
                }
                if (progress.getCompleted()) {
                    if (file) {
                        if (/\s/.test(file)) {
                            console.log(`${file} completed.`);
                        }
                        else {
                            console.log(`Download of '${file}' completed.`);
                        }
                    }
                    else {
                        console.log('The library index has been successfully updated.');
                    }
                    file = undefined;
                }
            }
        });
        await new Promise((resolve, reject) => {
            resp.on('error', reject);
            resp.on('end', resolve);
        });
    }
    async updateIndex({ client, instance, }) {
        const updateReq = new commands_pb_1.UpdateIndexRequest();
        updateReq.setInstance(instance);
        const updateResp = client.updateIndex(updateReq);
        let file;
        updateResp.on('data', (o) => {
            const progress = o.getDownloadProgress();
            if (progress) {
                if (!file && progress.getFile()) {
                    file = `${progress.getFile()}`;
                }
                if (progress.getCompleted()) {
                    if (file) {
                        if (/\s/.test(file)) {
                            console.log(`${file} completed.`);
                        }
                        else {
                            console.log(`Download of '${file}' completed.`);
                        }
                    }
                    else {
                        console.log('The index has been successfully updated.');
                    }
                    file = undefined;
                }
            }
        });
        await new Promise((resolve, reject) => {
            updateResp.on('error', reject);
            updateResp.on('end', resolve);
        });
    }
};
__decorate([
    inversify_1.inject(protocol_1.NotificationServiceServer),
    __metadata("design:type", Object)
], CoreClientProvider.prototype, "notificationService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], CoreClientProvider.prototype, "init", null);
CoreClientProvider = __decorate([
    inversify_1.injectable()
], CoreClientProvider);
exports.CoreClientProvider = CoreClientProvider;
let CoreClientAware = class CoreClientAware {
    async coreClient() {
        return await new Promise(async (resolve, reject) => {
            const client = await this.coreClientProvider.client();
            if (client && client instanceof Error) {
                reject(client);
            }
            else if (client) {
                return resolve(client);
            }
        });
    }
};
__decorate([
    inversify_1.inject(CoreClientProvider),
    __metadata("design:type", CoreClientProvider)
], CoreClientAware.prototype, "coreClientProvider", void 0);
CoreClientAware = __decorate([
    inversify_1.injectable()
], CoreClientAware);
exports.CoreClientAware = CoreClientAware;
//# sourceMappingURL=core-client-provider.js.map