"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCliConfig = exports.Logging = exports.Directories = exports.BoardManager = exports.CLI_CONFIG = void 0;
const config_service_1 = require("../common/protocol/config-service");
exports.CLI_CONFIG = 'arduino-cli.yaml';
var BoardManager;
(function (BoardManager) {
    function sameAs(left, right) {
        const leftOrDefault = left || {};
        const rightOrDefault = right || {};
        const leftUrls = Array.from(new Set(leftOrDefault.additional_urls || []));
        const rightUrls = Array.from(new Set(rightOrDefault.additional_urls || []));
        if (leftUrls.length !== rightUrls.length) {
            return false;
        }
        return leftUrls.every((url) => rightUrls.indexOf(url) !== -1);
    }
    BoardManager.sameAs = sameAs;
})(BoardManager = exports.BoardManager || (exports.BoardManager = {}));
var Directories;
(function (Directories) {
    function is(directories) {
        return (!!directories &&
            !!directories.data &&
            !!directories.downloads &&
            !!directories.user);
    }
    Directories.is = is;
    function sameAs(left, right) {
        if (left === undefined) {
            return right === undefined;
        }
        if (right === undefined) {
            return left === undefined;
        }
        return (left.data === right.data &&
            left.downloads === right.downloads &&
            left.user === right.user);
    }
    Directories.sameAs = sameAs;
})(Directories = exports.Directories || (exports.Directories = {}));
var Logging;
(function (Logging) {
    function sameAs(left, right) {
        if (left === undefined) {
            return right === undefined;
        }
        if (right === undefined) {
            return left === undefined;
        }
        if (left.file !== right.file) {
            return false;
        }
        if (left.format !== right.format) {
            return false;
        }
        if (left.level !== right.level) {
            return false;
        }
        return true;
    }
    Logging.sameAs = sameAs;
})(Logging = exports.Logging || (exports.Logging = {}));
var DefaultCliConfig;
(function (DefaultCliConfig) {
    function is(config) {
        return (!!config && Directories.is(config.directories) && config_service_1.Daemon.is(config.daemon));
    }
    DefaultCliConfig.is = is;
    function sameAs(left, right) {
        return (Directories.sameAs(left.directories, right.directories) &&
            config_service_1.Daemon.sameAs(left.daemon, right.daemon) &&
            BoardManager.sameAs(left.board_manager, right.board_manager) &&
            Logging.sameAs(left.logging, right.logging));
    }
    DefaultCliConfig.sameAs = sameAs;
})(DefaultCliConfig = exports.DefaultCliConfig || (exports.DefaultCliConfig = {}));
//# sourceMappingURL=cli-config.js.map