"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BoardsServiceImpl = void 0;
const inversify_1 = require("inversify");
const logger_1 = require("@theia/core/lib/common/logger");
const objects_1 = require("@theia/core/lib/common/objects");
const protocol_1 = require("../common/protocol");
const core_pb_1 = require("./cli-protocol/cc/arduino/cli/commands/v1/core_pb");
const board_discovery_1 = require("./board-discovery");
const core_client_provider_1 = require("./core-client-provider");
const board_pb_1 = require("./cli-protocol/cc/arduino/cli/commands/v1/board_pb");
const upload_pb_1 = require("./cli-protocol/cc/arduino/cli/commands/v1/upload_pb");
const grpc_installable_1 = require("./grpc-installable");
let BoardsServiceImpl = class BoardsServiceImpl extends core_client_provider_1.CoreClientAware {
    async getState() {
        return this.boardDiscovery.state;
    }
    async getAttachedBoards() {
        return this.boardDiscovery.getAttachedBoards();
    }
    async getAvailablePorts() {
        return this.boardDiscovery.getAvailablePorts();
    }
    async getBoardDetails(options) {
        await this.coreClientProvider.initialized;
        const coreClient = await this.coreClient();
        const { client, instance } = coreClient;
        const { fqbn } = options;
        const detailsReq = new board_pb_1.BoardDetailsRequest();
        detailsReq.setInstance(instance);
        detailsReq.setFqbn(fqbn);
        const detailsResp = await new Promise((resolve, reject) => client.boardDetails(detailsReq, (err, resp) => {
            if (err) {
                // Required cores are not installed manually: https://github.com/arduino/arduino-cli/issues/954
                if ((err.message.indexOf('missing platform release') !== -1 &&
                    err.message.indexOf('referenced by board') !== -1) ||
                    // Platform is not installed.
                    (err.message.indexOf('platform') !== -1 &&
                        err.message.indexOf('not installed') !== -1)) {
                    resolve(undefined);
                    return;
                }
                // It's a hack to handle https://github.com/arduino/arduino-cli/issues/1262 gracefully.
                if (err.message.indexOf('unknown package') !== -1) {
                    resolve(undefined);
                    return;
                }
                reject(err);
                return;
            }
            resolve(resp);
        }));
        if (!detailsResp) {
            return undefined;
        }
        const debuggingSupported = detailsResp.getDebuggingSupported();
        const requiredTools = detailsResp.getToolsDependenciesList().map((t) => ({
            name: t.getName(),
            packager: t.getPackager(),
            version: t.getVersion(),
        }));
        const configOptions = detailsResp.getConfigOptionsList().map((c) => ({
            label: c.getOptionLabel(),
            option: c.getOption(),
            values: c.getValuesList().map((v) => ({
                value: v.getValue(),
                label: v.getValueLabel(),
                selected: v.getSelected(),
            })),
        }));
        const listReq = new upload_pb_1.ListProgrammersAvailableForUploadRequest();
        listReq.setInstance(instance);
        listReq.setFqbn(fqbn);
        const listResp = await new Promise((resolve, reject) => client.listProgrammersAvailableForUpload(listReq, (err, resp) => {
            if (err) {
                reject(err);
                return;
            }
            resolve(resp);
        }));
        const programmers = listResp.getProgrammersList().map((p) => ({
            id: p.getId(),
            name: p.getName(),
            platform: p.getPlatform(),
        }));
        let VID = 'N/A';
        let PID = 'N/A';
        const prop = detailsResp
            .getIdentificationPropertiesList()
            .map((item) => item.getPropertiesMap())
            .find(objects_1.notEmpty);
        if (prop) {
            VID = prop.get('vid') || '';
            PID = prop.get('pid') || '';
        }
        return {
            fqbn,
            requiredTools,
            configOptions,
            programmers,
            debuggingSupported,
            VID,
            PID,
        };
    }
    async getBoardPackage(options) {
        const { id: expectedId } = options;
        if (!expectedId) {
            return undefined;
        }
        const packages = await this.search({ query: expectedId });
        return packages.find(({ id }) => id === expectedId);
    }
    async getContainerBoardPackage(options) {
        const { fqbn: expectedFqbn } = options;
        if (!expectedFqbn) {
            return undefined;
        }
        const packages = await this.search({});
        return packages.find(({ boards }) => boards.some(({ fqbn }) => fqbn === expectedFqbn));
    }
    async searchBoards({ query, }) {
        await this.coreClientProvider.initialized;
        const { instance, client } = await this.coreClient();
        const req = new board_pb_1.BoardSearchRequest();
        req.setSearchArgs(query || '');
        req.setInstance(instance);
        const boards = await new Promise((resolve, reject) => {
            client.boardSearch(req, (error, resp) => {
                if (error) {
                    reject(error);
                    return;
                }
                const boards = [];
                for (const board of resp.getBoardsList()) {
                    const platform = board.getPlatform();
                    if (platform) {
                        boards.push({
                            name: board.getName(),
                            fqbn: board.getFqbn(),
                            packageId: platform.getId(),
                            packageName: platform.getName(),
                            manuallyInstalled: platform.getManuallyInstalled(),
                        });
                    }
                }
                resolve(boards);
            });
        });
        return boards;
    }
    async getBoardUserFields(options) {
        await this.coreClientProvider.initialized;
        const coreClient = await this.coreClient();
        const { client, instance } = coreClient;
        const supportedUserFieldsReq = new upload_pb_1.SupportedUserFieldsRequest();
        supportedUserFieldsReq.setInstance(instance);
        supportedUserFieldsReq.setFqbn(options.fqbn);
        supportedUserFieldsReq.setProtocol(options.protocol);
        const supportedUserFieldsResp = await new Promise((resolve, reject) => {
            client.supportedUserFields(supportedUserFieldsReq, (err, resp) => {
                (!!err ? reject : resolve)(!!err ? err : resp);
            });
        });
        return supportedUserFieldsResp.getUserFieldsList().map((e) => {
            return {
                toolId: e.getToolId(),
                name: e.getName(),
                label: e.getLabel(),
                secret: e.getSecret(),
                value: '',
            };
        });
    }
    async search(options) {
        await this.coreClientProvider.initialized;
        const coreClient = await this.coreClient();
        const { client, instance } = coreClient;
        const installedPlatformsReq = new core_pb_1.PlatformListRequest();
        installedPlatformsReq.setInstance(instance);
        const installedPlatformsResp = await new Promise((resolve, reject) => client.platformList(installedPlatformsReq, (err, resp) => (!!err ? reject : resolve)(!!err ? err : resp)));
        const installedPlatforms = installedPlatformsResp.getInstalledPlatformsList();
        const req = new core_pb_1.PlatformSearchRequest();
        req.setSearchArgs(options.query || '');
        req.setAllVersions(true);
        req.setInstance(instance);
        const resp = await new Promise((resolve, reject) => client.platformSearch(req, (err, resp) => (!!err ? reject : resolve)(!!err ? err : resp)));
        const packages = new Map();
        const toPackage = (platform) => {
            let installedVersion;
            const matchingPlatform = installedPlatforms.find((ip) => ip.getId() === platform.getId());
            if (!!matchingPlatform) {
                installedVersion = matchingPlatform.getInstalled();
            }
            return {
                id: platform.getId(),
                name: platform.getName(),
                author: platform.getMaintainer(),
                availableVersions: [platform.getLatest()],
                description: platform
                    .getBoardsList()
                    .map((b) => b.getName())
                    .join(', '),
                installable: true,
                deprecated: platform.getDeprecated(),
                summary: 'Boards included in this package:',
                installedVersion,
                boards: platform
                    .getBoardsList()
                    .map((b) => ({ name: b.getName(), fqbn: b.getFqbn() })),
                moreInfoLink: platform.getWebsite(),
            };
        };
        // We must group the cores by ID, and sort platforms by, first the installed version, then version alphabetical order.
        // Otherwise we lose the FQBN information.
        const groupedById = new Map();
        for (const platform of resp.getSearchOutputList()) {
            const id = platform.getId();
            if (groupedById.has(id)) {
                groupedById.get(id).push(platform);
            }
            else {
                groupedById.set(id, [platform]);
            }
        }
        const installedAwareVersionComparator = (left, right) => {
            // XXX: we cannot rely on `platform.getInstalled()`, it is always an empty string.
            const leftInstalled = !!installedPlatforms.find((ip) => ip.getId() === left.getId() && ip.getInstalled() === left.getLatest());
            const rightInstalled = !!installedPlatforms.find((ip) => ip.getId() === right.getId() &&
                ip.getInstalled() === right.getLatest());
            if (leftInstalled && !rightInstalled) {
                return -1;
            }
            if (!leftInstalled && rightInstalled) {
                return 1;
            }
            return protocol_1.Installable.Version.COMPARATOR(left.getLatest(), right.getLatest()); // Higher version comes first.
        };
        for (const id of groupedById.keys()) {
            groupedById.get(id).sort(installedAwareVersionComparator);
        }
        for (const id of groupedById.keys()) {
            for (const platform of groupedById.get(id)) {
                const id = platform.getId();
                const pkg = packages.get(id);
                if (pkg) {
                    pkg.availableVersions.push(platform.getLatest());
                    pkg.availableVersions.sort(protocol_1.Installable.Version.COMPARATOR).reverse();
                }
                else {
                    packages.set(id, toPackage(platform));
                }
            }
        }
        return [...packages.values()];
    }
    async install(options) {
        const item = options.item;
        const version = !!options.version
            ? options.version
            : item.availableVersions[0];
        await this.coreClientProvider.initialized;
        const coreClient = await this.coreClient();
        const { client, instance } = coreClient;
        const [platform, architecture] = item.id.split(':');
        const req = new core_pb_1.PlatformInstallRequest();
        req.setInstance(instance);
        req.setArchitecture(architecture);
        req.setPlatformPackage(platform);
        req.setVersion(version);
        console.info('>>> Starting boards package installation...', item);
        // stop the board discovery
        await this.boardDiscovery.stopBoardListWatch(coreClient);
        const resp = client.platformInstall(req);
        resp.on('data', grpc_installable_1.InstallWithProgress.createDataCallback({
            progressId: options.progressId,
            responseService: this.responseService,
        }));
        await new Promise((resolve, reject) => {
            resp.on('end', () => {
                this.boardDiscovery.startBoardListWatch(coreClient);
                resolve();
            });
            resp.on('error', (error) => {
                this.responseService.appendToOutput({
                    chunk: `Failed to install platform: ${item.id}.\n`,
                });
                this.responseService.appendToOutput({
                    chunk: error.toString(),
                });
                reject(error);
            });
        });
        const items = await this.search({});
        const updated = items.find((other) => protocol_1.BoardsPackage.equals(other, item)) || item;
        this.notificationService.notifyPlatformInstalled({ item: updated });
        console.info('<<< Boards package installation done.', item);
    }
    async uninstall(options) {
        const { item, progressId } = options;
        await this.coreClientProvider.initialized;
        const coreClient = await this.coreClient();
        const { client, instance } = coreClient;
        const [platform, architecture] = item.id.split(':');
        const req = new core_pb_1.PlatformUninstallRequest();
        req.setInstance(instance);
        req.setArchitecture(architecture);
        req.setPlatformPackage(platform);
        console.info('>>> Starting boards package uninstallation...', item);
        // stop the board discovery
        await this.boardDiscovery.stopBoardListWatch(coreClient);
        const resp = client.platformUninstall(req);
        resp.on('data', grpc_installable_1.InstallWithProgress.createDataCallback({
            progressId,
            responseService: this.responseService,
        }));
        await new Promise((resolve, reject) => {
            resp.on('end', () => {
                this.boardDiscovery.startBoardListWatch(coreClient);
                resolve();
            });
            resp.on('error', reject);
        });
        // Here, unlike at `install` we send out the argument `item`. Otherwise, we would not know about the board FQBN.
        this.notificationService.notifyPlatformUninstalled({ item });
        console.info('<<< Boards package uninstallation done.', item);
    }
};
__decorate([
    inversify_1.inject(logger_1.ILogger),
    __metadata("design:type", Object)
], BoardsServiceImpl.prototype, "logger", void 0);
__decorate([
    inversify_1.inject(logger_1.ILogger),
    inversify_1.named('discovery'),
    __metadata("design:type", Object)
], BoardsServiceImpl.prototype, "discoveryLogger", void 0);
__decorate([
    inversify_1.inject(protocol_1.ResponseService),
    __metadata("design:type", Object)
], BoardsServiceImpl.prototype, "responseService", void 0);
__decorate([
    inversify_1.inject(protocol_1.NotificationServiceServer),
    __metadata("design:type", Object)
], BoardsServiceImpl.prototype, "notificationService", void 0);
__decorate([
    inversify_1.inject(board_discovery_1.BoardDiscovery),
    __metadata("design:type", board_discovery_1.BoardDiscovery)
], BoardsServiceImpl.prototype, "boardDiscovery", void 0);
BoardsServiceImpl = __decorate([
    inversify_1.injectable()
], BoardsServiceImpl);
exports.BoardsServiceImpl = BoardsServiceImpl;
//# sourceMappingURL=boards-service-impl.js.map