"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateProofKeyPair = exports.getRandomValues = exports.IToken2Session = exports.token2IToken = exports.IToken = void 0;
const jwt_decode_1 = require("jwt-decode");
const hash_js_1 = require("hash.js");
const crypto_1 = require("crypto");
const btoa = require("btoa"); // TODO: check why we cannot
var IToken;
(function (IToken) {
    // check if the token is expired or will expired before the buffer
    function requiresRefresh(token, buffer) {
        return token.expiresAt ? token.expiresAt < Date.now() + buffer : false;
    }
    IToken.requiresRefresh = requiresRefresh;
})(IToken = exports.IToken || (exports.IToken = {}));
function token2IToken(token) {
    const parsedIdToken = (token.id_token && jwt_decode_1.default(token.id_token)) || {};
    return {
        idToken: token.id_token,
        expiresIn: token.expires_in,
        expiresAt: token.expires_in
            ? Date.now() + token.expires_in * 1000
            : undefined,
        accessToken: token.access_token,
        refreshToken: token.refresh_token,
        sessionId: parsedIdToken.sub,
        scope: token.scope,
        account: {
            id: parsedIdToken.sub || 'unknown',
            email: parsedIdToken.email || 'unknown',
            nickname: parsedIdToken.nickname || 'unknown',
            picture: parsedIdToken.picture || 'unknown',
        },
    };
}
exports.token2IToken = token2IToken;
function IToken2Session(token) {
    return {
        accessToken: token.accessToken,
        account: {
            id: token.account.id,
            label: token.account.nickname,
            picture: token.account.picture,
            email: token.account.email,
        },
        id: token.account.id,
        scopes: token.scope.split(' '),
    };
}
exports.IToken2Session = IToken2Session;
function getRandomValues(input) {
    const bytes = crypto_1.randomBytes(input.length);
    for (let i = 0, n = bytes.length; i < n; ++i) {
        input[i] = bytes[i];
    }
    return input;
}
exports.getRandomValues = getRandomValues;
function generateProofKeyPair() {
    const urlEncode = (str) => str.replace(/\+/g, '-').replace(/\//g, '_').replace(/=/g, '');
    const decode = (buffer) => {
        let decodedString = '';
        for (let i = 0; i < buffer.length; i++) {
            decodedString += String.fromCharCode(buffer[i]);
        }
        return decodedString;
    };
    const buffer = getRandomValues(new Uint8Array(32));
    const seed = btoa(decode(buffer));
    const verifier = urlEncode(seed);
    const challenge = urlEncode(btoa(decode(hash_js_1.sha256().update(verifier).digest())));
    return { verifier, challenge };
}
exports.generateProofKeyPair = generateProofKeyPair;
//# sourceMappingURL=utils.js.map