"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Keychain = void 0;
class Keychain {
    constructor(config) {
        this.credentialsSection = config.credentialsSection;
        this.account = config.account;
    }
    getKeytar() {
        try {
            return require('keytar');
        }
        catch (err) {
            console.log(err);
        }
        return undefined;
    }
    async getStoredCredentials() {
        const keytar = this.getKeytar();
        if (!keytar) {
            return undefined;
        }
        try {
            return keytar.getPassword(this.credentialsSection, this.account);
        }
        catch (_a) {
            return undefined;
        }
    }
    async storeCredentials(stringifiedToken) {
        const keytar = this.getKeytar();
        if (!keytar) {
            return false;
        }
        try {
            await keytar.setPassword(this.credentialsSection, this.account, stringifiedToken);
            return true;
        }
        catch (_a) {
            return false;
        }
    }
    async deleteCredentials() {
        const keytar = this.getKeytar();
        if (!keytar) {
            return false;
        }
        try {
            const result = await keytar.deletePassword(this.credentialsSection, this.account);
            return result;
        }
        catch (_a) {
            return false;
        }
    }
}
exports.Keychain = Keychain;
//# sourceMappingURL=keychain.js.map