"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticationServiceImpl = void 0;
const inversify_1 = require("inversify");
const disposable_1 = require("@theia/core/lib/common/disposable");
const arduino_auth_provider_1 = require("./arduino-auth-provider");
let AuthenticationServiceImpl = class AuthenticationServiceImpl {
    constructor() {
        this.delegate = new arduino_auth_provider_1.ArduinoAuthenticationProvider();
        this.clients = [];
        this.toDispose = new disposable_1.DisposableCollection();
    }
    async onStart() {
        this.toDispose.pushAll([
            this.delegate,
            this.delegate.onDidChangeSessions(({ added, removed, changed }) => {
                added === null || added === void 0 ? void 0 : added.forEach((session) => this.clients.forEach((client) => client.notifySessionDidChange(session)));
                changed === null || changed === void 0 ? void 0 : changed.forEach((session) => this.clients.forEach((client) => client.notifySessionDidChange(session)));
                removed === null || removed === void 0 ? void 0 : removed.forEach(() => this.clients.forEach((client) => client.notifySessionDidChange()));
            }),
            disposable_1.Disposable.create(() => this.clients.forEach((client) => this.disposeClient(client))),
        ]);
        await this.delegate.init();
    }
    setOptions(authOptions) {
        this.delegate.setOptions(authOptions);
    }
    async login() {
        return this.delegate.createSession();
    }
    async logout() {
        this.delegate.logout();
    }
    async session() {
        const sessions = await this.delegate.getSessions();
        return sessions[0];
    }
    dispose() {
        this.toDispose.dispose();
    }
    setClient(client) {
        if (client) {
            this.clients.push(client);
        }
    }
    disposeClient(client) {
        const index = this.clients.indexOf(client);
        if (index === -1) {
            console.warn('Could not dispose authentications service client. It was not registered. Skipping.');
            return;
        }
        this.clients.splice(index, 1);
    }
};
AuthenticationServiceImpl = __decorate([
    inversify_1.injectable()
], AuthenticationServiceImpl);
exports.AuthenticationServiceImpl = AuthenticationServiceImpl;
//# sourceMappingURL=authentication-service-impl.js.map