"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.startServer = exports.createServer = exports.serverPort = exports.authCallbackPath = void 0;
const http = require("http");
const url = require("url");
const body_1 = require("./body");
exports.authCallbackPath = 'callback';
exports.serverPort = 9876;
function createServer(authCallback) {
    const server = http.createServer(function (req, res) {
        const reqUrl = url.parse(req.url, /* parseQueryString */ true);
        switch (reqUrl.pathname) {
            case `/${exports.authCallbackPath}`:
                authCallback(req, res);
                res.writeHead(200, {
                    'Content-Length': body_1.body.length,
                    'Content-Type': 'text/html; charset=utf-8',
                });
                res.end(body_1.body);
                break;
            default:
                res.writeHead(404);
                res.end();
                break;
        }
    });
    return server;
}
exports.createServer = createServer;
async function startServer(server) {
    let portTimer;
    function cancelPortTimer() {
        clearTimeout(portTimer);
    }
    const port = new Promise((resolve, reject) => {
        portTimer = setTimeout(() => {
            reject(new Error('Timeout waiting for port'));
        }, 5000);
        server.on('listening', () => {
            const address = server.address();
            if (typeof address === 'undefined' || address === null) {
                reject(new Error('address is null or undefined'));
            }
            else if (typeof address === 'string') {
                resolve(address);
            }
            else {
                resolve(address.port.toString());
            }
        });
        server.on('error', (_) => {
            reject(new Error('Error listening to server'));
        });
        server.on('close', () => {
            reject(new Error('Closed'));
        });
        server.listen(exports.serverPort);
    });
    port.then(cancelPortTimer, cancelPortTimer);
    return port;
}
exports.startServer = startServer;
//# sourceMappingURL=authentication-server.js.map