"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const inversify_1 = require("inversify");
const arduino_daemon_impl_1 = require("./arduino-daemon-impl");
const arduino_firmware_uploader_1 = require("../common/protocol/arduino-firmware-uploader");
const logger_1 = require("@theia/core/lib/common/logger");
const backend_application_1 = require("@theia/core/lib/node/backend-application");
const library_service_1 = require("../common/protocol/library-service");
const boards_service_1 = require("../common/protocol/boards-service");
const library_service_server_impl_1 = require("./library-service-server-impl");
const boards_service_impl_1 = require("./boards-service-impl");
const core_service_impl_1 = require("./core-service-impl");
const core_service_1 = require("../common/protocol/core-service");
const connection_container_module_1 = require("@theia/core/lib/node/messaging/connection-container-module");
const core_client_provider_1 = require("./core-client-provider");
const core_1 = require("@theia/core");
const default_workspace_server_1 = require("./theia/workspace/default-workspace-server");
const common_1 = require("@theia/workspace/lib/common");
const sketches_service_impl_1 = require("./sketches-service-impl");
const sketches_service_1 = require("../common/protocol/sketches-service");
const config_service_1 = require("../common/protocol/config-service");
const arduino_daemon_1 = require("../common/protocol/arduino-daemon");
const serial_service_impl_1 = require("./serial/serial-service-impl");
const serial_service_1 = require("../common/protocol/serial-service");
const monitor_client_provider_1 = require("./serial/monitor-client-provider");
const config_service_impl_1 = require("./config-service-impl");
const env_variables_1 = require("@theia/core/lib/common/env-variables");
const env_variables_server_1 = require("./theia/env-variables/env-variables-server");
const node_filesystem_ext_1 = require("./node-filesystem-ext");
const filesystem_ext_1 = require("../common/protocol/filesystem-ext");
const examples_service_impl_1 = require("./examples-service-impl");
const examples_service_1 = require("../common/protocol/examples-service");
const executable_service_1 = require("../common/protocol/executable-service");
const executable_service_impl_1 = require("./executable-service-impl");
const response_service_1 = require("../common/protocol/response-service");
const notification_service_server_1 = require("./notification-service-server");
const protocol_1 = require("../common/protocol");
const backend_application_2 = require("./theia/core/backend-application");
const board_discovery_1 = require("./board-discovery");
const git_init_1 = require("./theia/git/git-init");
const git_init_2 = require("@theia/git/lib/node/init/git-init");
const authentication_service_impl_1 = require("./auth/authentication-service-impl");
const authentication_service_1 = require("../common/protocol/authentication-service");
const arduino_firmware_uploader_impl_1 = require("./arduino-firmware-uploader-impl");
const plotter_backend_contribution_1 = require("./plotter/plotter-backend-contribution");
const web_socket_service_impl_1 = require("./web-socket/web-socket-service-impl");
const web_socket_service_1 = require("./web-socket/web-socket-service");
exports.default = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    bind(backend_application_2.BackendApplication).toSelf().inSingletonScope();
    rebind(backend_application_1.BackendApplication).toService(backend_application_2.BackendApplication);
    // Shared config service
    bind(config_service_impl_1.ConfigServiceImpl).toSelf().inSingletonScope();
    bind(config_service_1.ConfigService).toService(config_service_impl_1.ConfigServiceImpl);
    // Note: The config service must start earlier than the daemon, hence the binding order of the BA contribution does matter.
    bind(backend_application_1.BackendApplicationContribution).toService(config_service_impl_1.ConfigServiceImpl);
    bind(core_1.ConnectionHandler)
        .toDynamicValue((context) => new core_1.JsonRpcConnectionHandler(config_service_1.ConfigServicePath, () => context.container.get(config_service_1.ConfigService)))
        .inSingletonScope();
    // Shared daemon
    bind(arduino_daemon_impl_1.ArduinoDaemonImpl).toSelf().inSingletonScope();
    bind(arduino_daemon_1.ArduinoDaemon).toService(arduino_daemon_impl_1.ArduinoDaemonImpl);
    bind(backend_application_1.BackendApplicationContribution).toService(arduino_daemon_impl_1.ArduinoDaemonImpl);
    bind(core_1.ConnectionHandler)
        .toDynamicValue((context) => new core_1.JsonRpcConnectionHandler(arduino_daemon_1.ArduinoDaemonPath, () => context.container.get(arduino_daemon_1.ArduinoDaemon)))
        .inSingletonScope();
    // Examples service. One per backend, each connected FE gets a proxy.
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(connection_container_module_1.ConnectionContainerModule.create(({ bind, bindBackendService }) => {
        bind(examples_service_impl_1.ExamplesServiceImpl).toSelf().inSingletonScope();
        bind(examples_service_1.ExamplesService).toService(examples_service_impl_1.ExamplesServiceImpl);
        bindBackendService(examples_service_1.ExamplesServicePath, examples_service_1.ExamplesService);
    }));
    // Exposes the executable paths/URIs to the frontend
    bind(executable_service_impl_1.ExecutableServiceImpl).toSelf().inSingletonScope();
    bind(executable_service_1.ExecutableService).toService(executable_service_impl_1.ExecutableServiceImpl);
    bind(core_1.ConnectionHandler)
        .toDynamicValue((context) => new core_1.JsonRpcConnectionHandler(executable_service_1.ExecutableServicePath, () => context.container.get(executable_service_1.ExecutableService)))
        .inSingletonScope();
    // Library service. Singleton per backend, each connected FE gets its proxy.
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(connection_container_module_1.ConnectionContainerModule.create(({ bind, bindBackendService }) => {
        bind(library_service_server_impl_1.LibraryServiceImpl).toSelf().inSingletonScope();
        bind(library_service_1.LibraryService).toService(library_service_server_impl_1.LibraryServiceImpl);
        bindBackendService(library_service_1.LibraryServicePath, library_service_1.LibraryService);
    }));
    // Shared sketches service
    bind(sketches_service_impl_1.SketchesServiceImpl).toSelf().inSingletonScope();
    bind(sketches_service_1.SketchesService).toService(sketches_service_impl_1.SketchesServiceImpl);
    bind(core_1.ConnectionHandler)
        .toDynamicValue((context) => new core_1.JsonRpcConnectionHandler(sketches_service_1.SketchesServicePath, () => context.container.get(sketches_service_1.SketchesService)))
        .inSingletonScope();
    // Boards service. One instance per connected frontend.
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(connection_container_module_1.ConnectionContainerModule.create(({ bind, bindBackendService }) => {
        bind(boards_service_impl_1.BoardsServiceImpl).toSelf().inSingletonScope();
        bind(boards_service_1.BoardsService).toService(boards_service_impl_1.BoardsServiceImpl);
        bindBackendService(boards_service_1.BoardsServicePath, boards_service_1.BoardsService);
    }));
    // Shared WebSocketService for the backend. This will manage all websocket conenctions
    bind(web_socket_service_1.WebSocketService).to(web_socket_service_impl_1.default).inSingletonScope();
    // Shared Arduino core client provider service for the backend.
    bind(core_client_provider_1.CoreClientProvider).toSelf().inSingletonScope();
    // Shared port/board discovery for the server
    bind(board_discovery_1.BoardDiscovery).toSelf().inSingletonScope();
    // Core service -> `verify` and `upload`. Singleton per BE, each FE connection gets its proxy.
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(connection_container_module_1.ConnectionContainerModule.create(({ bind, bindBackendService }) => {
        bind(core_service_impl_1.CoreServiceImpl).toSelf().inSingletonScope();
        bind(core_service_1.CoreService).toService(core_service_impl_1.CoreServiceImpl);
        bindBackendService(core_service_1.CoreServicePath, core_service_1.CoreService);
    }));
    // #region Theia customizations
    bind(default_workspace_server_1.DefaultWorkspaceServer).toSelf().inSingletonScope();
    rebind(common_1.WorkspaceServer).toService(default_workspace_server_1.DefaultWorkspaceServer);
    bind(env_variables_server_1.EnvVariablesServer).toSelf().inSingletonScope();
    rebind(env_variables_1.EnvVariablesServer).toService(env_variables_server_1.EnvVariablesServer);
    // #endregion Theia customizations
    // Serial client provider per connected frontend.
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(connection_container_module_1.ConnectionContainerModule.create(({ bind, bindBackendService }) => {
        bind(monitor_client_provider_1.MonitorClientProvider).toSelf().inSingletonScope();
        bind(serial_service_impl_1.SerialServiceImpl).toSelf().inSingletonScope();
        bind(serial_service_1.SerialService).toService(serial_service_impl_1.SerialServiceImpl);
        bindBackendService(serial_service_1.SerialServicePath, serial_service_1.SerialService, (service, client) => {
            service.setClient(client);
            client.onDidCloseConnection(() => service.dispose());
            return service;
        });
    }));
    // File-system extension for mapping paths to URIs
    bind(node_filesystem_ext_1.NodeFileSystemExt).toSelf().inSingletonScope();
    bind(filesystem_ext_1.FileSystemExt).toService(node_filesystem_ext_1.NodeFileSystemExt);
    bind(core_1.ConnectionHandler)
        .toDynamicValue((context) => new core_1.JsonRpcConnectionHandler(filesystem_ext_1.FileSystemExtPath, () => context.container.get(filesystem_ext_1.FileSystemExt)))
        .inSingletonScope();
    // Output service per connection.
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(connection_container_module_1.ConnectionContainerModule.create(({ bindFrontendService }) => {
        bindFrontendService(response_service_1.ResponseServicePath, response_service_1.ResponseService);
    }));
    // Notify all connected frontend instances
    bind(notification_service_server_1.NotificationServiceServerImpl).toSelf().inSingletonScope();
    bind(protocol_1.NotificationServiceServer).toService(notification_service_server_1.NotificationServiceServerImpl);
    bind(core_1.ConnectionHandler)
        .toDynamicValue((context) => new core_1.JsonRpcConnectionHandler(protocol_1.NotificationServicePath, (client) => {
        const server = context.container.get(protocol_1.NotificationServiceServer);
        server.setClient(client);
        client.onDidCloseConnection(() => server.disposeClient(client));
        return server;
    }))
        .inSingletonScope();
    // Singleton per BE, each FE connection gets its proxy.
    bind(connection_container_module_1.ConnectionContainerModule).toConstantValue(connection_container_module_1.ConnectionContainerModule.create(({ bind, bindBackendService }) => {
        bind(arduino_firmware_uploader_impl_1.ArduinoFirmwareUploaderImpl).toSelf().inSingletonScope();
        bind(arduino_firmware_uploader_1.ArduinoFirmwareUploader).toService(arduino_firmware_uploader_impl_1.ArduinoFirmwareUploaderImpl);
        bindBackendService(arduino_firmware_uploader_1.ArduinoFirmwareUploaderPath, arduino_firmware_uploader_1.ArduinoFirmwareUploader);
    }));
    // Logger for the Arduino daemon
    bind(logger_1.ILogger)
        .toDynamicValue((ctx) => {
        const parentLogger = ctx.container.get(logger_1.ILogger);
        return parentLogger.child('daemon');
    })
        .inSingletonScope()
        .whenTargetNamed('daemon');
    // Logger for the Arduino daemon
    bind(logger_1.ILogger)
        .toDynamicValue((ctx) => {
        const parentLogger = ctx.container.get(logger_1.ILogger);
        return parentLogger.child('fwuploader');
    })
        .inSingletonScope()
        .whenTargetNamed('fwuploader');
    // Logger for the "serial discovery".
    bind(logger_1.ILogger)
        .toDynamicValue((ctx) => {
        const parentLogger = ctx.container.get(logger_1.ILogger);
        return parentLogger.child('discovery');
    })
        .inSingletonScope()
        .whenTargetNamed('discovery');
    // Logger for the CLI config service. From the CLI config (FS path aware), we make a URI-aware app config.
    bind(logger_1.ILogger)
        .toDynamicValue((ctx) => {
        const parentLogger = ctx.container.get(logger_1.ILogger);
        return parentLogger.child('config');
    })
        .inSingletonScope()
        .whenTargetNamed('config');
    // Logger for the serial service.
    bind(logger_1.ILogger)
        .toDynamicValue((ctx) => {
        const parentLogger = ctx.container.get(logger_1.ILogger);
        return parentLogger.child(serial_service_impl_1.SerialServiceName);
    })
        .inSingletonScope()
        .whenTargetNamed(serial_service_impl_1.SerialServiceName);
    bind(git_init_1.DefaultGitInit).toSelf();
    rebind(git_init_2.GitInit).toService(git_init_1.DefaultGitInit);
    // Remote sketchbook bindings
    bind(authentication_service_impl_1.AuthenticationServiceImpl).toSelf().inSingletonScope();
    bind(authentication_service_1.AuthenticationService).toService(authentication_service_impl_1.AuthenticationServiceImpl);
    bind(backend_application_1.BackendApplicationContribution).toService(authentication_service_impl_1.AuthenticationServiceImpl);
    bind(core_1.ConnectionHandler)
        .toDynamicValue((context) => new core_1.JsonRpcConnectionHandler(authentication_service_1.AuthenticationServicePath, (client) => {
        const server = context.container.get(authentication_service_impl_1.AuthenticationServiceImpl);
        server.setClient(client);
        client.onDidCloseConnection(() => server.disposeClient(client));
        return server;
    }))
        .inSingletonScope();
    bind(plotter_backend_contribution_1.PlotterBackendContribution).toSelf().inSingletonScope();
    bind(backend_application_1.BackendApplicationContribution).toService(plotter_backend_contribution_1.PlotterBackendContribution);
});
//# sourceMappingURL=arduino-ide-backend-module.js.map