"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArduinoFirmwareUploaderImpl = void 0;
const inversify_1 = require("inversify");
const protocol_1 = require("../common/protocol");
const serial_service_1 = require("../common/protocol/serial-service");
const exec_util_1 = require("./exec-util");
const logger_1 = require("@theia/core/lib/common/logger");
let ArduinoFirmwareUploaderImpl = class ArduinoFirmwareUploaderImpl {
    onError(error) {
        this.logger.error(error);
    }
    async getExecPath() {
        if (this._execPath) {
            return this._execPath;
        }
        this._execPath = await exec_util_1.getExecPath('arduino-fwuploader');
        return this._execPath;
    }
    async runCommand(args) {
        const execPath = await this.getExecPath();
        return await exec_util_1.spawnCommand(`"${execPath}"`, args, this.onError.bind(this));
    }
    async uploadCertificates(command) {
        return await this.runCommand(['certificates', 'flash', command]);
    }
    async list(fqbn) {
        const fqbnFlag = fqbn ? ['--fqbn', fqbn] : [];
        const firmwares = JSON.parse(await this.runCommand([
            'firmware',
            'list',
            ...fqbnFlag,
            '--format',
            'json',
        ])) || [];
        return firmwares.reverse();
    }
    async updatableBoards() {
        return (await this.list()).reduce((a, b) => (a.includes(b.board_fqbn) ? a : [...a, b.board_fqbn]), []);
    }
    async availableFirmwares(fqbn) {
        return await this.list(fqbn);
    }
    async flash(firmware, port) {
        let output;
        try {
            this.serialService.uploadInProgress = true;
            await this.serialService.disconnect();
            output = await this.runCommand([
                'firmware',
                'flash',
                '--fqbn',
                firmware.board_fqbn,
                '--address',
                port,
                '--module',
                `${firmware.module}@${firmware.firmware_version}`,
            ]);
        }
        catch (e) {
            throw e;
        }
        finally {
            this.serialService.uploadInProgress = false;
            this.serialService.connectSerialIfRequired();
            return output;
        }
    }
};
__decorate([
    inversify_1.inject(protocol_1.ExecutableService),
    __metadata("design:type", Object)
], ArduinoFirmwareUploaderImpl.prototype, "executableService", void 0);
__decorate([
    inversify_1.inject(logger_1.ILogger),
    inversify_1.named('fwuploader'),
    __metadata("design:type", Object)
], ArduinoFirmwareUploaderImpl.prototype, "logger", void 0);
__decorate([
    inversify_1.inject(serial_service_1.SerialService),
    __metadata("design:type", Object)
], ArduinoFirmwareUploaderImpl.prototype, "serialService", void 0);
ArduinoFirmwareUploaderImpl = __decorate([
    inversify_1.injectable()
], ArduinoFirmwareUploaderImpl);
exports.ArduinoFirmwareUploaderImpl = ArduinoFirmwareUploaderImpl;
//# sourceMappingURL=arduino-firmware-uploader-impl.js.map