"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElectronMainWindowServiceImpl = void 0;
const inversify_1 = require("inversify");
const electron_main_window_service_impl_1 = require("@theia/core/lib/electron-main/electron-main-window-service-impl");
const electron_main_application_1 = require("./electron-main-application");
let ElectronMainWindowServiceImpl = class ElectronMainWindowServiceImpl extends electron_main_window_service_impl_1.ElectronMainWindowServiceImpl {
    openNewWindow(url, { external }) {
        if (!external) {
            const sanitizedUrl = this.sanitize(url);
            const existing = this.app.windows.find((window) => this.sanitize(window.webContents.getURL()) === sanitizedUrl);
            if (existing) {
                existing.focus();
                return;
            }
        }
        return super.openNewWindow(url, { external });
    }
    sanitize(url) {
        const copy = new URL(url);
        const searchParams = [];
        copy.searchParams.forEach((_, key) => searchParams.push(key));
        for (const param of searchParams) {
            copy.searchParams.delete(param);
        }
        return copy.toString();
    }
};
__decorate([
    inversify_1.inject(electron_main_application_1.ElectronMainApplication),
    __metadata("design:type", electron_main_application_1.ElectronMainApplication)
], ElectronMainWindowServiceImpl.prototype, "app", void 0);
ElectronMainWindowServiceImpl = __decorate([
    inversify_1.injectable()
], ElectronMainWindowServiceImpl);
exports.ElectronMainWindowServiceImpl = ElectronMainWindowServiceImpl;
//# sourceMappingURL=electron-main-window-service.js.map