"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IDEUpdaterImpl = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const electron_updater_1 = require("electron-updater");
const node_fetch_1 = require("node-fetch");
const arduino_preferences_1 = require("../../browser/arduino-preferences");
const CHANGELOG_BASE_URL = 'https://downloads.arduino.cc/arduino-ide/changelog';
let IDEUpdaterImpl = class IDEUpdaterImpl {
    constructor() {
        this.isAlreadyChecked = false;
        this.updater = electron_updater_1.autoUpdater;
        this.clients = [];
        this.updater.on('checking-for-update', (e) => {
            this.clients.forEach((c) => c.notifyCheckingForUpdate(e));
        });
        this.updater.on('update-available', (e) => {
            this.clients.forEach((c) => c.notifyUpdateAvailable(e));
        });
        this.updater.on('update-not-available', (e) => {
            this.clients.forEach((c) => c.notifyUpdateNotAvailable(e));
        });
        this.updater.on('download-progress', (e) => {
            this.clients.forEach((c) => c.notifyDownloadProgressChanged(e));
        });
        this.updater.on('update-downloaded', (e) => {
            this.clients.forEach((c) => c.notifyDownloadFinished(e));
        });
        this.updater.on('error', (e) => {
            this.clients.forEach((c) => c.notifyError(e));
        });
    }
    async init(channel, baseUrl) {
        this.updater.autoDownload = false;
        this.updater.channel = channel;
        this.updater.setFeedURL({
            provider: 'generic',
            url: `${baseUrl}/${channel === arduino_preferences_1.UpdateChannel.Nightly ? 'nightly' : ''}`,
            channel,
        });
    }
    setClient(client) {
        if (client)
            this.clients.push(client);
    }
    async checkForUpdates(initialCheck) {
        if (initialCheck) {
            if (this.isAlreadyChecked)
                return Promise.resolve();
            this.isAlreadyChecked = true;
        }
        const { updateInfo, cancellationToken, } = await this.updater.checkForUpdates();
        this.cancellationToken = cancellationToken;
        if (this.updater.currentVersion.compare(updateInfo.version) === -1) {
            /*
              'latest.txt' points to the latest changelog that has been generated by the CI,
              so we need to make a first GET request to get the filename of the changelog
              and a second GET to the actual changelog file
            */
            try {
                let response = await node_fetch_1.default(`${CHANGELOG_BASE_URL}/latest.txt`);
                const latestChangelogFileName = response.ok
                    ? await response.text()
                    : null;
                response = latestChangelogFileName
                    ? await node_fetch_1.default(`${CHANGELOG_BASE_URL}/${latestChangelogFileName}`)
                    : null;
                const changelog = (response === null || response === void 0 ? void 0 : response.ok) ? await (response === null || response === void 0 ? void 0 : response.text()) : null;
                // We only want to see the release notes of newer versions
                const currentVersionIndex = changelog === null || changelog === void 0 ? void 0 : changelog.indexOf(`\r\n\r\n---\r\n\r\n## ${this.updater.currentVersion}\r\n\r\n`);
                const newChangelog = currentVersionIndex && currentVersionIndex > 0
                    ? changelog === null || changelog === void 0 ? void 0 : changelog.slice(0, currentVersionIndex) : changelog;
                updateInfo.releaseNotes = newChangelog;
            }
            catch (_a) {
                /*
                  if the request for the changelog fails, we'll just avoid to show it
                  to the user, but we will still show the update info
                */
            }
            return updateInfo;
        }
    }
    async downloadUpdate() {
        try {
            await this.updater.downloadUpdate(this.cancellationToken);
        }
        catch (e) {
            if (e.message === 'cancelled')
                return;
            this.clients.forEach((c) => c.notifyError(e));
        }
    }
    stopDownload() {
        var _a;
        (_a = this.cancellationToken) === null || _a === void 0 ? void 0 : _a.cancel();
    }
    quitAndInstall() {
        this.updater.quitAndInstall();
    }
    disconnectClient(client) {
        const index = this.clients.indexOf(client);
        if (index !== -1) {
            this.clients.splice(index, 1);
        }
    }
    dispose() {
        this.clients.forEach(this.disconnectClient.bind(this));
    }
};
IDEUpdaterImpl = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], IDEUpdaterImpl);
exports.IDEUpdaterImpl = IDEUpdaterImpl;
//# sourceMappingURL=ide-updater-impl.js.map