"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const inversify_1 = require("inversify");
const proxy_factory_1 = require("@theia/core/lib/common/messaging/proxy-factory");
const electron_connection_handler_1 = require("@theia/core/lib/electron-common/messaging/electron-connection-handler");
const electron_main_window_service_1 = require("@theia/core/lib/electron-common/electron-main-window-service");
const electron_main_application_1 = require("@theia/core/lib/electron-main/electron-main-application");
const splash_service_1 = require("../electron-common/splash-service");
const splash_service_impl_1 = require("./splash/splash-service-impl");
const electron_main_application_2 = require("./theia/electron-main-application");
const electron_main_window_service_2 = require("./theia/electron-main-window-service");
const ide_updater_1 = require("../common/protocol/ide-updater");
const ide_updater_impl_1 = require("./ide-updater/ide-updater-impl");
exports.default = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    bind(electron_main_application_2.ElectronMainApplication).toSelf().inSingletonScope();
    rebind(electron_main_application_1.ElectronMainApplication).toService(electron_main_application_2.ElectronMainApplication);
    bind(electron_main_window_service_2.ElectronMainWindowServiceImpl).toSelf().inSingletonScope();
    rebind(electron_main_window_service_1.ElectronMainWindowService).toService(electron_main_window_service_2.ElectronMainWindowServiceImpl);
    bind(splash_service_impl_1.SplashServiceImpl).toSelf().inSingletonScope();
    bind(splash_service_1.SplashService).toService(splash_service_impl_1.SplashServiceImpl);
    bind(electron_connection_handler_1.ElectronConnectionHandler)
        .toDynamicValue((context) => new proxy_factory_1.JsonRpcConnectionHandler(splash_service_1.splashServicePath, () => context.container.get(splash_service_1.SplashService)))
        .inSingletonScope();
    // IDE updater bindings
    bind(ide_updater_impl_1.IDEUpdaterImpl).toSelf().inSingletonScope();
    bind(ide_updater_1.IDEUpdater).toService(ide_updater_impl_1.IDEUpdaterImpl);
    bind(electron_main_application_1.ElectronMainApplicationContribution).toService(ide_updater_1.IDEUpdater);
    bind(electron_connection_handler_1.ElectronConnectionHandler)
        .toDynamicValue((context) => new proxy_factory_1.JsonRpcConnectionHandler(ide_updater_1.IDEUpdaterPath, (client) => {
        const server = context.container.get(ide_updater_1.IDEUpdater);
        server.setClient(client);
        client.onDidCloseConnection(() => server.disconnectClient(client));
        return server;
    }))
        .inSingletonScope();
});
//# sourceMappingURL=arduino-electron-main-module.js.map