"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const inversify_1 = require("inversify");
const window_service_1 = require("@theia/core/lib/browser/window/window-service");
const electron_main_menu_factory_1 = require("@theia/core/lib/electron-browser/menu/electron-main-menu-factory");
const electron_menu_contribution_1 = require("@theia/core/lib/electron-browser/menu/electron-menu-contribution");
const electron_ipc_connection_provider_1 = require("@theia/core/lib/electron-browser/messaging/electron-ipc-connection-provider");
const splash_service_1 = require("../../../electron-common/splash-service");
const main_menu_manager_1 = require("../../../common/main-menu-manager");
const electron_window_service_1 = require("../../electron-window-service");
const electron_main_menu_factory_2 = require("./electron-main-menu-factory");
const electron_menu_contribution_2 = require("./electron-menu-contribution");
exports.default = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    bind(electron_menu_contribution_2.ElectronMenuContribution).toSelf().inSingletonScope();
    bind(main_menu_manager_1.MainMenuManager).toService(electron_menu_contribution_2.ElectronMenuContribution);
    rebind(electron_menu_contribution_1.ElectronMenuContribution).to(electron_menu_contribution_2.ElectronMenuContribution);
    bind(electron_main_menu_factory_2.ElectronMainMenuFactory).toSelf().inRequestScope();
    rebind(electron_main_menu_factory_1.ElectronMainMenuFactory).toService(electron_main_menu_factory_2.ElectronMainMenuFactory);
    bind(electron_window_service_1.ElectronWindowService).toSelf().inSingletonScope();
    rebind(window_service_1.WindowService).toService(electron_window_service_1.ElectronWindowService);
    bind(splash_service_1.SplashService)
        .toDynamicValue((context) => electron_ipc_connection_provider_1.ElectronIpcConnectionProvider.createProxy(context.container, splash_service_1.splashServicePath))
        .inSingletonScope();
});
//# sourceMappingURL=electron-menu-module.js.map