"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElectronMenuContribution = void 0;
const inversify_1 = require("inversify");
const electron_menu_contribution_1 = require("@theia/core/lib/electron-browser/menu/electron-menu-contribution");
let ElectronMenuContribution = class ElectronMenuContribution extends electron_menu_contribution_1.ElectronMenuContribution {
    hideTopPanel() {
        // NOOP
        // We reuse the `div` for the Arduino toolbar.
    }
    update() {
        this.setMenu();
    }
    registerCommands(registry) {
        super.registerCommands(registry);
        registry.unregisterCommand(electron_menu_contribution_1.ElectronCommands.CLOSE_WINDOW);
    }
    registerMenus(registry) {
        super.registerMenus(registry);
        registry.unregisterMenuAction(electron_menu_contribution_1.ElectronCommands.CLOSE_WINDOW);
    }
    registerKeybindings(registry) {
        super.registerKeybindings(registry);
        registry.unregisterKeybinding(electron_menu_contribution_1.ElectronCommands.CLOSE_WINDOW.id);
        registry.unregisterKeybinding(electron_menu_contribution_1.ElectronCommands.ZOOM_IN.id);
        registry.unregisterKeybinding(electron_menu_contribution_1.ElectronCommands.ZOOM_OUT.id);
    }
};
ElectronMenuContribution = __decorate([
    inversify_1.injectable()
], ElectronMenuContribution);
exports.ElectronMenuContribution = ElectronMenuContribution;
//# sourceMappingURL=electron-menu-contribution.js.map