"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElectronMainMenuFactory = void 0;
const inversify_1 = require("inversify");
const remote = require("@theia/core/electron-shared/@electron/remote");
const os_1 = require("@theia/core/lib/common/os");
const menu_1 = require("@theia/core/lib/common/menu");
const electron_main_menu_factory_1 = require("@theia/core/lib/electron-browser/menu/electron-main-menu-factory");
const arduino_menus_1 = require("../../../browser/menu/arduino-menus");
let ElectronMainMenuFactory = class ElectronMainMenuFactory extends electron_main_menu_factory_1.ElectronMainMenuFactory {
    createElectronMenuBar() {
        this._toggledCommands.clear(); // https://github.com/eclipse-theia/theia/issues/8977
        const menuModel = this.menuProvider.getMenu(menu_1.MAIN_MENU_BAR);
        const template = this.fillMenuTemplate([], menuModel);
        if (os_1.isOSX) {
            template.unshift(this.createOSXMenu());
        }
        const menu = remote.Menu.buildFromTemplate(this.escapeAmpersand(template));
        this._menu = menu;
        return menu;
    }
    async setMenuBar() {
        await this.preferencesService.ready;
        const createdMenuBar = this.createElectronMenuBar();
        if (os_1.isOSX) {
            remote.Menu.setApplicationMenu(createdMenuBar);
        }
        else {
            remote.getCurrentWindow().setMenu(createdMenuBar);
        }
    }
    createElectronContextMenu(menuPath, args) {
        const menuModel = this.menuProvider.getMenu(menuPath);
        const template = this.fillMenuTemplate([], menuModel, args, {
            showDisabled: false,
        });
        return remote.Menu.buildFromTemplate(this.escapeAmpersand(template));
    }
    // TODO: remove after https://github.com/eclipse-theia/theia/pull/9231
    escapeAmpersand(template) {
        for (const option of template) {
            if (option.label) {
                option.label = option.label.replace(/\&+/g, '&$&');
            }
            if (option.submenu) {
                this.escapeAmpersand(option.submenu);
            }
        }
        return template;
    }
    acceleratorFor(keybinding) {
        // TODO: https://github.com/eclipse-theia/theia/issues/8207
        return this.keybindingRegistry
            .resolveKeybinding(keybinding)
            .map((binding) => this.keybindingRegistry.acceleratorForKeyCode(binding, '+'))
            .join('')
            .replace('←', 'Left')
            .replace('→', 'Right');
    }
    createOSXMenu() {
        const { submenu } = super.createOSXMenu();
        const label = 'Arduino IDE';
        if (!!submenu && Array.isArray(submenu)) {
            const [, , /* about */ /* preferences */ ...rest] = submenu;
            const about = this.fillMenuTemplate([], this.menuProvider.getMenu(arduino_menus_1.ArduinoMenus.HELP__ABOUT_GROUP));
            const preferences = this.fillMenuTemplate([], this.menuProvider.getMenu(arduino_menus_1.ArduinoMenus.FILE__PREFERENCES_GROUP));
            const advanced = this.fillMenuTemplate([], this.menuProvider.getMenu(arduino_menus_1.ArduinoMenus.FILE__ADVANCED_GROUP));
            return {
                label,
                submenu: [
                    ...about,
                    { type: 'separator' },
                    ...preferences,
                    ...advanced,
                    { type: 'separator' },
                    ...rest,
                ],
            };
        }
        return { label, submenu };
    }
    handleElectronDefault(menuNode, args = [], options) {
        if (menuNode instanceof arduino_menus_1.PlaceholderMenuNode) {
            return [
                {
                    label: menuNode.label,
                    enabled: false,
                    visible: true,
                },
            ];
        }
        return [];
    }
};
ElectronMainMenuFactory = __decorate([
    inversify_1.injectable()
], ElectronMainMenuFactory);
exports.ElectronMainMenuFactory = ElectronMainMenuFactory;
//# sourceMappingURL=electron-main-menu-factory.js.map