"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElectronWindowService = void 0;
const inversify_1 = require("inversify");
const remote = require("@theia/core/electron-shared/@electron/remote");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
const connection_status_service_1 = require("@theia/core/lib/browser/connection-status-service");
const electron_window_service_1 = require("@theia/core/lib/electron-browser/window/electron-window-service");
const splash_service_1 = require("../electron-common/splash-service");
const common_1 = require("@theia/core/lib/common");
let ElectronWindowService = class ElectronWindowService extends electron_window_service_1.ElectronWindowService {
    init() {
        this.appStateService
            .reachedAnyState('initialized_layout')
            .then(() => this.splashService.requestClose());
    }
    shouldUnload() {
        const offline = this.connectionStatusService.currentStatus === connection_status_service_1.ConnectionStatus.OFFLINE;
        const detail = offline
            ? common_1.nls.localize('arduino/electron/couldNotSave', 'Could not save the sketch. Please copy your unsaved work into your favorite text editor, and restart the IDE.')
            : common_1.nls.localize('arduino/electron/unsavedChanges', 'Any unsaved changes will not be saved.');
        const electronWindow = remote.getCurrentWindow();
        const response = remote.dialog.showMessageBoxSync(electronWindow, {
            type: 'question',
            buttons: [
                common_1.nls.localize('vscode/extensionsUtils/yes', 'Yes'),
                common_1.nls.localize('vscode/extensionsUtils/no', 'No'),
            ],
            title: common_1.nls.localize('vscode/Default/ConfirmTitle', 'Confirm'),
            message: common_1.nls.localize('arduino/sketch/close', 'Are you sure you want to close the sketch?'),
            detail,
        });
        return response === 0; // 'Yes', close the window.
    }
};
__decorate([
    inversify_1.inject(connection_status_service_1.ConnectionStatusService),
    __metadata("design:type", Object)
], ElectronWindowService.prototype, "connectionStatusService", void 0);
__decorate([
    inversify_1.inject(splash_service_1.SplashService),
    __metadata("design:type", Object)
], ElectronWindowService.prototype, "splashService", void 0);
__decorate([
    inversify_1.inject(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], ElectronWindowService.prototype, "appStateService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ElectronWindowService.prototype, "init", null);
ElectronWindowService = __decorate([
    inversify_1.injectable()
], ElectronWindowService);
exports.ElectronWindowService = ElectronWindowService;
//# sourceMappingURL=electron-window-service.js.map