"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SketchContainer = exports.Sketch = exports.SketchesService = exports.SketchesServicePath = void 0;
const uri_1 = require("@theia/core/lib/common/uri");
exports.SketchesServicePath = '/services/sketches-service';
exports.SketchesService = Symbol('SketchesService');
var Sketch;
(function (Sketch) {
    function is(arg) {
        return (!!arg &&
            'name' in arg &&
            'uri' in arg &&
            typeof arg.name === 'string' &&
            typeof arg.uri === 'string');
    }
    Sketch.is = is;
    let Extensions;
    (function (Extensions) {
        Extensions.MAIN = ['.ino', '.pde'];
        Extensions.SOURCE = ['.c', '.cpp', '.s'];
        Extensions.ADDITIONAL = [
            '.h',
            '.c',
            '.hpp',
            '.hh',
            '.cpp',
            '.S',
            '.json',
            '.md',
            '.adoc',
        ];
        Extensions.ALL = Array.from(new Set([...Extensions.MAIN, ...Extensions.SOURCE, ...Extensions.ADDITIONAL]));
    })(Extensions = Sketch.Extensions || (Sketch.Extensions = {}));
    function isInSketch(uri, sketch) {
        const { mainFileUri, otherSketchFileUris, additionalFileUris } = sketch;
        return ([mainFileUri, ...otherSketchFileUris, ...additionalFileUris].indexOf(uri.toString()) !== -1);
    }
    Sketch.isInSketch = isInSketch;
    function isSketchFile(arg) {
        if (arg instanceof uri_1.default) {
            return isSketchFile(arg.toString());
        }
        return Extensions.MAIN.some((ext) => arg.endsWith(ext));
    }
    Sketch.isSketchFile = isSketchFile;
})(Sketch = exports.Sketch || (exports.Sketch = {}));
var SketchContainer;
(function (SketchContainer) {
    function is(arg) {
        return (!!arg &&
            'label' in arg &&
            typeof arg.label === 'string' &&
            'children' in arg &&
            Array.isArray(arg.children) &&
            'sketches' in arg &&
            Array.isArray(arg.sketches));
    }
    SketchContainer.is = is;
    /**
     * `false` if the `container` recursively contains at least one sketch. Otherwise, `true`.
     */
    function isEmpty(container) {
        const hasSketch = (parent) => {
            if (parent.sketches.length ||
                parent.children.some((child) => hasSketch(child))) {
                return true;
            }
            return false;
        };
        return !hasSketch(container);
    }
    SketchContainer.isEmpty = isEmpty;
    function prune(container) {
        for (let i = container.children.length - 1; i >= 0; i--) {
            if (isEmpty(container.children[i])) {
                container.children.splice(i, 1);
            }
        }
        return container;
    }
    SketchContainer.prune = prune;
    function toArray(container) {
        const visit = (parent, toPushSketch) => {
            toPushSketch.push(...parent.sketches);
            parent.children.map((child) => visit(child, toPushSketch));
        };
        const sketches = [];
        visit(container, sketches);
        return sketches;
    }
    SketchContainer.toArray = toArray;
})(SketchContainer = exports.SketchContainer || (exports.SketchContainer = {}));
//# sourceMappingURL=sketches-service.js.map