"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SketchesServiceClientImpl = void 0;
const inversify_1 = require("inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const event_1 = require("@theia/core/lib/common/event");
const objects_1 = require("@theia/core/lib/common/objects");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const message_service_1 = require("@theia/core/lib/common/message-service");
const workspace_service_1 = require("@theia/workspace/lib/browser/workspace-service");
const disposable_1 = require("@theia/core/lib/common/disposable");
const protocol_1 = require("../../common/protocol");
const config_service_1 = require("./config-service");
const sketches_service_1 = require("./sketches-service");
const READ_ONLY_FILES = [
    'thingProperties.h',
    'thingsProperties.h',
    'sketch.json',
];
let SketchesServiceClientImpl = class SketchesServiceClientImpl {
    constructor() {
        this.toDispose = new disposable_1.DisposableCollection();
        this.sketches = new Map();
        this.sketchbookDidChangeEmitter = new event_1.Emitter();
        this.onSketchbookDidChange = this.sketchbookDidChangeEmitter.event;
        this.bufferedSketchbookEvents = [];
    }
    onStart() {
        this.configService.getConfiguration().then(({ sketchDirUri }) => {
            this.sketchService
                .getSketches({ uri: sketchDirUri })
                .then((container) => {
                const sketchbookUri = new uri_1.default(sketchDirUri);
                for (const sketch of sketches_service_1.SketchContainer.toArray(container)) {
                    this.sketches.set(sketch.uri, sketch);
                }
                this.toDispose.push(this.fileService.watch(new uri_1.default(sketchDirUri), {
                    recursive: true,
                    excludes: [],
                }));
                this.toDispose.push(this.fileService.onDidFilesChange(async (event) => {
                    for (const { type, resource } of event.changes) {
                        // We track main sketch files changes only. // TODO: check sketch folder changes. One can rename the folder without renaming the `.ino` file.
                        if (sketchbookUri.isEqualOrParent(resource)) {
                            if (protocol_1.Sketch.isSketchFile(resource)) {
                                if (type === 1 /* ADDED */) {
                                    try {
                                        const toAdd = await this.sketchService.loadSketch(resource.parent.toString());
                                        if (!this.sketches.has(toAdd.uri)) {
                                            console.log(`New sketch '${toAdd.name}' was crated in sketchbook '${sketchDirUri}'.`);
                                            this.sketches.set(toAdd.uri, toAdd);
                                            this.fireSoon(toAdd, 'created');
                                        }
                                    }
                                    catch (_a) { }
                                }
                                else if (type === 2 /* DELETED */) {
                                    const uri = resource.parent.toString();
                                    const toDelete = this.sketches.get(uri);
                                    if (toDelete) {
                                        console.log(`Sketch '${toDelete.name}' was removed from sketchbook '${sketchbookUri}'.`);
                                        this.sketches.delete(uri);
                                        this.fireSoon(toDelete, 'removed');
                                    }
                                }
                            }
                        }
                    }
                }));
            });
        });
    }
    onStop() {
        this.toDispose.dispose();
    }
    async currentSketch() {
        const sketches = (await Promise.all(this.workspaceService
            .tryGetRoots()
            .map(({ resource }) => this.sketchService.getSketchFolder(resource.toString())))).filter(objects_1.notEmpty);
        if (!sketches.length) {
            return undefined;
        }
        if (sketches.length > 1) {
            console.log(`Multiple sketch folders were found in the workspace. Falling back to the first one. Sketch folders: ${JSON.stringify(sketches)}`);
        }
        return sketches[0];
    }
    async currentSketchFile() {
        const sketch = await this.currentSketch();
        if (sketch) {
            const uri = sketch.mainFileUri;
            const exists = await this.fileService.exists(new uri_1.default(uri));
            if (!exists) {
                this.messageService.warn(`Could not find sketch file: ${uri}`);
                return undefined;
            }
            return uri;
        }
        return undefined;
    }
    fireSoon(sketch, type) {
        this.bufferedSketchbookEvents.push({ type, sketch });
        if (typeof this.fireSoonHandle === 'number') {
            window.clearTimeout(this.fireSoonHandle);
        }
        this.fireSoonHandle = window.setTimeout(() => {
            const event = {
                created: [],
                removed: [],
            };
            for (const { type, sketch } of this.bufferedSketchbookEvents) {
                if (type === 'created') {
                    event.created.push(sketch);
                }
                else {
                    event.removed.push(sketch);
                }
            }
            this.sketchbookDidChangeEmitter.fire(event);
            this.bufferedSketchbookEvents.length = 0;
        }, 100);
    }
    /**
     * `true` if the `uri` is not contained in any of the opened workspaces. Otherwise, `false`.
     */
    isReadOnly(uri) {
        var _a;
        const toCheck = uri instanceof uri_1.default ? uri : new uri_1.default(uri);
        if (toCheck.scheme === 'user-storage') {
            return false;
        }
        if (READ_ONLY_FILES.includes((_a = toCheck === null || toCheck === void 0 ? void 0 : toCheck.path) === null || _a === void 0 ? void 0 : _a.base)) {
            return true;
        }
        const readOnly = !this.workspaceService
            .tryGetRoots()
            .some(({ resource }) => resource.isEqualOrParent(toCheck));
        return readOnly;
    }
};
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], SketchesServiceClientImpl.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], SketchesServiceClientImpl.prototype, "messageService", void 0);
__decorate([
    inversify_1.inject(protocol_1.SketchesService),
    __metadata("design:type", Object)
], SketchesServiceClientImpl.prototype, "sketchService", void 0);
__decorate([
    inversify_1.inject(workspace_service_1.WorkspaceService),
    __metadata("design:type", workspace_service_1.WorkspaceService)
], SketchesServiceClientImpl.prototype, "workspaceService", void 0);
__decorate([
    inversify_1.inject(config_service_1.ConfigService),
    __metadata("design:type", Object)
], SketchesServiceClientImpl.prototype, "configService", void 0);
SketchesServiceClientImpl = __decorate([
    inversify_1.injectable()
], SketchesServiceClientImpl);
exports.SketchesServiceClientImpl = SketchesServiceClientImpl;
//# sourceMappingURL=sketches-service-client-impl.js.map