"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SerialError = exports.SerialServiceClient = exports.SerialConfig = exports.SerialService = exports.SerialServicePath = exports.Status = void 0;
var Status;
(function (Status) {
    function isOK(status) {
        return !!status && typeof status.message !== 'string';
    }
    Status.isOK = isOK;
    Status.OK = {};
    Status.NOT_CONNECTED = { message: 'Not connected.' };
    Status.ALREADY_CONNECTED = {
        message: 'Already connected.',
    };
    Status.CONFIG_MISSING = {
        message: 'Serial Config missing.',
    };
})(Status = exports.Status || (exports.Status = {}));
exports.SerialServicePath = '/services/serial';
exports.SerialService = Symbol('SerialService');
var SerialConfig;
(function (SerialConfig) {
    SerialConfig.BaudRates = [
        300, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200,
    ];
    let BaudRate;
    (function (BaudRate) {
        BaudRate.DEFAULT = 9600;
    })(BaudRate = SerialConfig.BaudRate || (SerialConfig.BaudRate = {}));
    let ConnectionType;
    (function (ConnectionType) {
        ConnectionType[ConnectionType["SERIAL"] = 0] = "SERIAL";
    })(ConnectionType = SerialConfig.ConnectionType || (SerialConfig.ConnectionType = {}));
})(SerialConfig = exports.SerialConfig || (exports.SerialConfig = {}));
exports.SerialServiceClient = Symbol('SerialServiceClient');
var SerialError;
(function (SerialError) {
    let ErrorCodes;
    (function (ErrorCodes) {
        /**
         * The frontend has refreshed the browser, for instance.
         */
        ErrorCodes.CLIENT_CANCEL = 1;
        /**
         * When detaching a physical device when the duplex channel is still opened.
         */
        ErrorCodes.DEVICE_NOT_CONFIGURED = 2;
        /**
         * Another serial connection was opened on this port. For another electron-instance, Java IDE.
         */
        ErrorCodes.DEVICE_BUSY = 3;
    })(ErrorCodes = SerialError.ErrorCodes || (SerialError.ErrorCodes = {}));
})(SerialError = exports.SerialError || (exports.SerialError = {}));
//# sourceMappingURL=serial-service.js.map