"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LibraryPackage = exports.LibraryLocation = exports.LibraryService = exports.LibraryServicePath = void 0;
const arduino_component_1 = require("./arduino-component");
exports.LibraryServicePath = '/services/library-service';
exports.LibraryService = Symbol('LibraryService');
var LibraryLocation;
(function (LibraryLocation) {
    /**
     * In the `libraries` subdirectory of the Arduino IDE installation.
     */
    LibraryLocation[LibraryLocation["IDE_BUILTIN"] = 0] = "IDE_BUILTIN";
    /**
     * In the `libraries` subdirectory of the user directory (sketchbook).
     */
    LibraryLocation[LibraryLocation["USER"] = 1] = "USER";
    /**
     * In the `libraries` subdirectory of a platform.
     */
    LibraryLocation[LibraryLocation["PLATFORM_BUILTIN"] = 2] = "PLATFORM_BUILTIN";
    /**
     * When `LibraryLocation` is used in a context where a board is specified, this indicates the library is in the `libraries`
     * subdirectory of a platform referenced by the board's platform.
     */
    LibraryLocation[LibraryLocation["REFERENCED_PLATFORM_BUILTIN"] = 3] = "REFERENCED_PLATFORM_BUILTIN";
})(LibraryLocation = exports.LibraryLocation || (exports.LibraryLocation = {}));
var LibraryPackage;
(function (LibraryPackage) {
    function is(arg) {
        return (arduino_component_1.ArduinoComponent.is(arg) &&
            'includes' in arg &&
            Array.isArray(arg['includes']));
    }
    LibraryPackage.is = is;
    function equals(left, right) {
        return left.name === right.name && left.author === right.author;
    }
    LibraryPackage.equals = equals;
    function groupByLocation(packages) {
        const user = [];
        const rest = [];
        for (const pkg of packages) {
            if (pkg.location === LibraryLocation.USER) {
                user.push(pkg);
            }
            else {
                rest.push(pkg);
            }
        }
        return { user, rest };
    }
    LibraryPackage.groupByLocation = groupByLocation;
})(LibraryPackage = exports.LibraryPackage || (exports.LibraryPackage = {}));
//# sourceMappingURL=library-service.js.map