"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Config = exports.Network = exports.Daemon = exports.ConfigService = exports.ConfigServicePath = void 0;
exports.ConfigServicePath = '/services/config-service';
exports.ConfigService = Symbol('ConfigService');
var Daemon;
(function (Daemon) {
    function is(daemon) {
        return !!daemon && !!daemon.port;
    }
    Daemon.is = is;
    function sameAs(left, right) {
        if (left === undefined) {
            return right === undefined;
        }
        if (right === undefined) {
            return left === undefined;
        }
        return String(left.port) === String(right.port);
    }
    Daemon.sameAs = sameAs;
})(Daemon = exports.Daemon || (exports.Daemon = {}));
var Network;
(function (Network) {
    function Default() {
        return {
            protocol: 'http',
            hostname: '',
            port: '',
            username: '',
            password: '',
        };
    }
    Network.Default = Default;
    function parse(raw) {
        if (!raw) {
            return 'none';
        }
        try {
            // Patter: PROTOCOL://USER:PASS@HOSTNAME:PORT/
            const { protocol, hostname, password, username, port } = new URL(raw);
            return {
                protocol,
                hostname,
                password,
                username,
                port,
            };
        }
        catch (_a) {
            return 'none';
        }
    }
    Network.parse = parse;
    function stringify(network) {
        if (network === 'none') {
            return undefined;
        }
        const { protocol, hostname, password, username, port } = network;
        try {
            const defaultUrl = new URL(`${protocol ? protocol : 'http'}://${hostname ? hostname : '_'}`);
            return Object.assign(defaultUrl, {
                protocol,
                hostname,
                password,
                username,
                port,
            }).toString();
        }
        catch (_a) {
            return undefined;
        }
    }
    Network.stringify = stringify;
    function sameAs(left, right) {
        if (left === 'none') {
            return right === 'none';
        }
        if (right === 'none') {
            return false;
        }
        return (left.hostname === right.hostname &&
            left.password === right.password &&
            left.protocol === right.protocol &&
            left.username === right.username);
    }
    Network.sameAs = sameAs;
})(Network = exports.Network || (exports.Network = {}));
var Config;
(function (Config) {
    function sameAs(left, right) {
        const leftUrls = left.additionalUrls.sort();
        const rightUrls = right.additionalUrls.sort();
        if (leftUrls.length !== rightUrls.length) {
            return false;
        }
        for (let i = 0; i < leftUrls.length; i++) {
            if (leftUrls[i] !== rightUrls[i]) {
                return false;
            }
        }
        return (left.locale === right.locale &&
            left.dataDirUri === right.dataDirUri &&
            left.downloadsDirUri === right.downloadsDirUri &&
            left.sketchDirUri === right.sketchDirUri &&
            Network.sameAs(left.network, right.network));
    }
    Config.sameAs = sameAs;
})(Config = exports.Config || (exports.Config = {}));
//# sourceMappingURL=config-service.js.map