"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var SketchbookWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NoopDragOverDockPanel = exports.SketchbookWidget = void 0;
const inversify_1 = require("inversify");
const algorithm_1 = require("@phosphor/algorithm");
const widgets_1 = require("@phosphor/widgets");
const messaging_1 = require("@phosphor/messaging");
const disposable_1 = require("@theia/core/lib/common/disposable");
const widget_1 = require("@theia/core/lib/browser/widgets/widget");
const sketchbook_tree_widget_1 = require("./sketchbook-tree-widget");
const common_1 = require("@theia/core/lib/common");
let SketchbookWidget = SketchbookWidget_1 = class SketchbookWidget extends widget_1.BaseWidget {
    constructor() {
        super();
        this.id = 'arduino-sketchbook-widget';
        this.title.caption = SketchbookWidget_1.LABEL;
        this.title.label = SketchbookWidget_1.LABEL;
        this.title.iconClass = 'fa fa-arduino-folder';
        this.title.closable = true;
        this.node.tabIndex = 0;
        this.sketchbookTreesContainer = this.createTreesContainer();
    }
    init() {
        this.sketchbookTreesContainer.addWidget(this.localSketchbookTreeWidget);
    }
    onAfterAttach(message) {
        super.onAfterAttach(message);
        widgets_1.Widget.attach(this.sketchbookTreesContainer, this.node);
        this.toDisposeOnDetach.push(disposable_1.Disposable.create(() => widgets_1.Widget.detach(this.sketchbookTreesContainer)));
    }
    getTreeWidget() {
        return this.localSketchbookTreeWidget;
    }
    onActivateRequest(message) {
        super.onActivateRequest(message);
        // TODO: focus the active sketchbook
        // if (this.editor) {
        //     this.editor.focus();
        // } else {
        // }
        this.node.focus();
    }
    onResize(message) {
        super.onResize(message);
        messaging_1.MessageLoop.sendMessage(this.sketchbookTreesContainer, widgets_1.Widget.ResizeMessage.UnknownSize);
        for (const widget of algorithm_1.toArray(this.sketchbookTreesContainer.widgets())) {
            messaging_1.MessageLoop.sendMessage(widget, widgets_1.Widget.ResizeMessage.UnknownSize);
        }
    }
    onAfterShow(msg) {
        super.onAfterShow(msg);
        this.onResize(widgets_1.Widget.ResizeMessage.UnknownSize);
    }
    createTreesContainer() {
        const panel = new NoopDragOverDockPanel({
            spacing: 0,
            mode: 'single-document',
        });
        panel.addClass('sketchbook-trees-container');
        panel.node.tabIndex = -1;
        return panel;
    }
};
SketchbookWidget.LABEL = common_1.nls.localize('arduino/sketch/titleSketchbook', 'Sketchbook');
__decorate([
    inversify_1.inject(sketchbook_tree_widget_1.SketchbookTreeWidget),
    __metadata("design:type", sketchbook_tree_widget_1.SketchbookTreeWidget)
], SketchbookWidget.prototype, "localSketchbookTreeWidget", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SketchbookWidget.prototype, "init", null);
SketchbookWidget = SketchbookWidget_1 = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], SketchbookWidget);
exports.SketchbookWidget = SketchbookWidget;
class NoopDragOverDockPanel extends widgets_1.DockPanel {
    constructor(options) {
        super(options);
        NoopDragOverDockPanel.prototype['_evtDragOver'] = (event) => {
            event.preventDefault();
            event.stopPropagation();
            event.dropAction = 'none';
        };
    }
}
exports.NoopDragOverDockPanel = NoopDragOverDockPanel;
//# sourceMappingURL=sketchbook-widget.js.map