"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SketchbookTreeWidget = void 0;
const React = require("react");
const inversify_1 = require("inversify");
const command_1 = require("@theia/core/lib/common/command");
const tree_widget_1 = require("@theia/core/lib/browser/tree/tree-widget");
const editor_manager_1 = require("@theia/editor/lib/browser/editor-manager");
const browser_1 = require("@theia/filesystem/lib/browser");
const context_menu_renderer_1 = require("@theia/core/lib/browser/context-menu-renderer");
const sketchbook_tree_1 = require("./sketchbook-tree");
const sketchbook_tree_model_1 = require("./sketchbook-tree-model");
const arduino_preferences_1 = require("../../arduino-preferences");
const sketches_service_client_impl_1 = require("../../../common/protocol/sketches-service-client-impl");
const tree_selection_1 = require("@theia/core/lib/browser/tree/tree-selection");
const contribution_1 = require("../../contributions/contribution");
const common_1 = require("@theia/core/lib/common");
let SketchbookTreeWidget = class SketchbookTreeWidget extends browser_1.FileTreeWidget {
    constructor(props, model, contextMenuRenderer, editorManager) {
        super(props, model, contextMenuRenderer);
        this.props = props;
        this.model = model;
        this.contextMenuRenderer = contextMenuRenderer;
        this.editorManager = editorManager;
        this.currentSketchUri = '';
        this.id = 'arduino-sketchbook-tree-widget';
        this.title.iconClass = 'sketchbook-tree-icon';
        this.title.caption = common_1.nls.localize('arduino/sketch/titleLocalSketchbook', 'Local Sketchbook');
        this.title.closable = false;
    }
    async init() {
        super.init();
        // cache the current open sketch uri
        const currentSketch = await this.sketchServiceClient.currentSketch();
        this.currentSketchUri = (currentSketch && currentSketch.uri) || '';
    }
    createNodeClassNames(node, props) {
        const classNames = super.createNodeClassNames(node, props);
        if (sketchbook_tree_1.SketchbookTree.SketchDirNode.is(node) &&
            this.currentSketchUri === (node === null || node === void 0 ? void 0 : node.uri.toString())) {
            classNames.push('active-sketch');
        }
        return classNames;
    }
    renderIcon(node, props) {
        if (sketchbook_tree_1.SketchbookTree.SketchDirNode.is(node) || contribution_1.Sketch.isSketchFile(node.id)) {
            return React.createElement("div", { className: "sketch-folder-icon file-icon" });
        }
        const icon = this.toNodeIcon(node);
        if (icon) {
            return React.createElement("div", { className: icon + ' file-icon' });
        }
        return undefined;
    }
    renderTailDecorations(node, props) {
        return (React.createElement(React.Fragment, null,
            super.renderTailDecorations(node, props),
            this.renderInlineCommands(node)));
    }
    setHoverNodeId(id) {
        this.hoveredNodeId = id;
        this.update();
    }
    createNodeAttributes(node, props) {
        return Object.assign(Object.assign({}, super.createNodeAttributes(node, props)), { draggable: false, onMouseOver: () => this.setHoverNodeId(node.id), onMouseOut: () => this.setHoverNodeId(undefined) });
    }
    renderInlineCommands(node) {
        if (sketchbook_tree_1.SketchbookTree.SketchDirNode.is(node) && node.commands) {
            return Array.from(new Set(node.commands)).map((command) => this.renderInlineCommand(command.id, node));
        }
        return undefined;
    }
    renderInlineCommand(commandId, node, options) {
        const command = this.commandRegistry.getCommand(commandId);
        const icon = command === null || command === void 0 ? void 0 : command.iconClass;
        const args = Object.assign({ model: this.model, node: node }, options);
        if (command &&
            icon &&
            this.commandRegistry.isEnabled(commandId, args) &&
            this.commandRegistry.isVisible(commandId, args)) {
            const className = [
                tree_widget_1.TREE_NODE_SEGMENT_CLASS,
                tree_widget_1.TREE_NODE_TAIL_CLASS,
                icon,
                'theia-tree-view-inline-action',
                'sketchbook-commands-icons',
            ].join(' ');
            return (React.createElement("div", { key: `${commandId}--${node.id}`, className: className, title: (command === null || command === void 0 ? void 0 : command.label) || command.id, onClick: (event) => {
                    event.preventDefault();
                    event.stopPropagation();
                    this.commandRegistry.executeCommand(commandId, Object.assign(args, { event: event.nativeEvent }));
                } }));
        }
        return undefined;
    }
    handleClickEvent(node, event) {
        if (node) {
            if (!!this.props.multiSelect) {
                const shiftMask = this.hasShiftMask(event);
                const ctrlCmdMask = this.hasCtrlCmdMask(event);
                if (tree_selection_1.SelectableTreeNode.is(node)) {
                    if (shiftMask) {
                        this.model.selectRange(node);
                    }
                    else if (ctrlCmdMask) {
                        this.model.toggleNode(node);
                    }
                    else {
                        this.model.selectNode(node);
                    }
                }
            }
            else {
                if (tree_selection_1.SelectableTreeNode.is(node)) {
                    this.model.selectNode(node);
                }
            }
            event.stopPropagation();
        }
    }
    doToggle(event) {
        const nodeId = event.currentTarget.getAttribute('data-node-id');
        if (nodeId) {
            const node = this.model.getNode(nodeId);
            if (node && this.isExpandable(node)) {
                this.model.toggleNodeExpansion(node);
            }
        }
        event.stopPropagation();
    }
};
__decorate([
    inversify_1.inject(command_1.CommandRegistry),
    __metadata("design:type", command_1.CommandRegistry)
], SketchbookTreeWidget.prototype, "commandRegistry", void 0);
__decorate([
    inversify_1.inject(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], SketchbookTreeWidget.prototype, "arduinoPreferences", void 0);
__decorate([
    inversify_1.inject(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], SketchbookTreeWidget.prototype, "sketchServiceClient", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SketchbookTreeWidget.prototype, "init", null);
SketchbookTreeWidget = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(tree_widget_1.TreeProps)),
    __param(1, inversify_1.inject(sketchbook_tree_model_1.SketchbookTreeModel)),
    __param(2, inversify_1.inject(context_menu_renderer_1.ContextMenuRenderer)),
    __param(3, inversify_1.inject(editor_manager_1.EditorManager)),
    __metadata("design:paramtypes", [Object, sketchbook_tree_model_1.SketchbookTreeModel,
        context_menu_renderer_1.ContextMenuRenderer,
        editor_manager_1.EditorManager])
], SketchbookTreeWidget);
exports.SketchbookTreeWidget = SketchbookTreeWidget;
//# sourceMappingURL=sketchbook-tree-widget.js.map