"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSketchbookTreeWidget = exports.createSketchbookTreeContainer = void 0;
const tree_1 = require("@theia/core/lib/browser/tree");
const sketchbook_tree_1 = require("./sketchbook-tree");
const sketchbook_tree_model_1 = require("./sketchbook-tree-model");
const sketchbook_tree_widget_1 = require("./sketchbook-tree-widget");
function createSketchbookTreeContainer(parent) {
    const child = tree_1.createTreeContainer(parent);
    child.unbind(tree_1.TreeImpl);
    child.bind(sketchbook_tree_1.SketchbookTree).toSelf();
    child.rebind(tree_1.Tree).toService(sketchbook_tree_1.SketchbookTree);
    child.unbind(tree_1.TreeModelImpl);
    child.bind(sketchbook_tree_model_1.SketchbookTreeModel).toSelf();
    child.rebind(tree_1.TreeModel).toService(sketchbook_tree_model_1.SketchbookTreeModel);
    child.bind(sketchbook_tree_widget_1.SketchbookTreeWidget).toSelf();
    child.rebind(tree_1.TreeWidget).toService(sketchbook_tree_widget_1.SketchbookTreeWidget);
    return child;
}
exports.createSketchbookTreeContainer = createSketchbookTreeContainer;
function createSketchbookTreeWidget(parent) {
    return createSketchbookTreeContainer(parent).get(sketchbook_tree_widget_1.SketchbookTreeWidget);
}
exports.createSketchbookTreeWidget = createSketchbookTreeWidget;
//# sourceMappingURL=sketchbook-tree-container.js.map