"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListItemRenderer = void 0;
const React = require("react");
const inversify_1 = require("inversify");
const window_service_1 = require("@theia/core/lib/browser/window/window-service");
const common_1 = require("@theia/core/lib/common");
let ListItemRenderer = class ListItemRenderer {
    constructor() {
        this.onMoreInfoClick = (event) => {
            const { target } = event.nativeEvent;
            if (target instanceof HTMLAnchorElement) {
                this.windowService.openNewWindow(target.href, { external: true });
                event.nativeEvent.preventDefault();
            }
        };
    }
    renderItem(input, install, uninstall, onVersionChange) {
        const { item } = input;
        let nameAndAuthor;
        if (item.name && item.author) {
            const name = React.createElement("span", { className: "name" }, item.name);
            const author = React.createElement("span", { className: "author" }, item.author);
            nameAndAuthor = (React.createElement("span", null,
                name,
                " ",
                common_1.nls.localize('arduino/component/by', 'by'),
                " ",
                author));
        }
        else if (item.name) {
            nameAndAuthor = React.createElement("span", { className: "name" }, item.name);
        }
        else if (item.id) {
            nameAndAuthor = React.createElement("span", { className: "name" }, item.id);
        }
        else {
            nameAndAuthor = (React.createElement("span", { className: "name" }, common_1.nls.localize('arduino/common/unknown', 'Unknown')));
        }
        const onClickUninstall = () => uninstall(item);
        const installedVersion = !!item.installedVersion && (React.createElement("div", { className: "version-info" },
            React.createElement("span", { className: "version" }, common_1.nls.localize('arduino/component/version', 'Version {0}', item.installedVersion)),
            React.createElement("span", { className: "installed", onClick: onClickUninstall })));
        const summary = React.createElement("div", { className: "summary" }, item.summary);
        const description = React.createElement("div", { className: "summary" }, item.description);
        const moreInfo = !!item.moreInfoLink && (React.createElement("a", { href: item.moreInfoLink, onClick: this.onMoreInfoClick }, common_1.nls.localize('arduino/component/moreInfo', 'More info')));
        const onClickInstall = () => install(item);
        const installButton = item.installable && (React.createElement("button", { className: "theia-button install", onClick: onClickInstall }, common_1.nls.localize('arduino/component/install', 'INSTALL')));
        const onSelectChange = (event) => {
            const version = event.target.value;
            if (version) {
                onVersionChange(version);
            }
        };
        const versions = (() => {
            const { availableVersions } = item;
            if (availableVersions.length === 0) {
                return undefined;
            }
            else if (availableVersions.length === 1) {
                return React.createElement("label", null, availableVersions[0]);
            }
            else {
                return (React.createElement("select", { className: "theia-select", value: input.selectedVersion, onChange: onSelectChange }, item.availableVersions
                    .filter((version) => version !== item.installedVersion) // Filter the version that is currently installed.
                    .map((version) => (React.createElement("option", { value: version, key: version }, version)))));
            }
        })();
        return (React.createElement("div", { className: "component-list-item noselect" },
            React.createElement("div", { className: "header" },
                nameAndAuthor,
                installedVersion),
            React.createElement("div", { className: "content" },
                summary,
                description),
            React.createElement("div", { className: "info" }, moreInfo),
            React.createElement("div", { className: "footer" },
                installButton,
                versions)));
    }
};
__decorate([
    inversify_1.inject(window_service_1.WindowService),
    __metadata("design:type", Object)
], ListItemRenderer.prototype, "windowService", void 0);
ListItemRenderer = __decorate([
    inversify_1.injectable()
], ListItemRenderer);
exports.ListItemRenderer = ListItemRenderer;
//# sourceMappingURL=list-item-renderer.js.map