"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComponentList = void 0;
const React = require("react");
const component_list_item_1 = require("./component-list-item");
class ComponentList extends React.Component {
    constructor() {
        super(...arguments);
        this.setRef = (element) => {
            this.container = element || undefined;
        };
    }
    render() {
        return (React.createElement("div", { className: 'items-container', ref: this.setRef }, this.props.items.map((item) => this.createItem(item))));
    }
    componentDidMount() {
        if (this.container && this.props.resolveContainer) {
            this.props.resolveContainer(this.container);
        }
    }
    createItem(item) {
        return (React.createElement(component_list_item_1.ComponentListItem, { key: this.props.itemLabel(item), item: item, itemRenderer: this.props.itemRenderer, install: this.props.install, uninstall: this.props.uninstall }));
    }
}
exports.ComponentList = ComponentList;
//# sourceMappingURL=component-list.js.map